package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.sym.*;

/** STATIC/FRAME/REG LirNode */
public class LirSymRef extends LirNode {
  public final Symbol symbol;

  public LirSymRef(int id, int op, int t, Symbol sym, ImList opt) {
    super(id, op, t, opt);
    symbol = sym;
  }

  public LirNode makeCopy(LirFactory fac) {
    return this;
  }

  public String toString() {
    return (Debug.showId ? "$"+id+":" : "")
      + "(" + Op.toName(opCode)
      + Debug.TypePrefix + Type.toString(type)
      + " \"" + symbol.name + "\")";
  }

  public boolean equals(Object x) {
    return (x instanceof LirSymRef && super.equals(x)
            && symbol == ((LirSymRef)x).symbol);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
