
import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.opt.*;
import coins.backend.util.*;

/**
 * Back end of COINS compiler
 */
class BackEnd extends Object {
  public static void main(String[] args) throws IOException {
    if (args.length != 1) {
      System.err.println("java BackEnd lirfile");
      return;
    }
    PushbackReader stdin
      = new PushbackReader(new InputStreamReader(new FileInputStream(args[0])));
    PrintWriter stdout = new PrintWriter(System.out, true);
    Object sexp;

    try {
      while ((sexp = ImList.readSexp(stdin)) != null) {
        // System.err.println(sexp.toString());
        // Read LIR
        Module compileUnit = new Module(sexp, stdout);
        if (Debug.dumpModule)
          compileUnit.printIt(stdout);

        // Apply optimization
        IntroVirReg opt = new IntroVirReg(stdout);
        opt.apply(compileUnit);
        if (Debug.dumpModule) {
          stdout.println("After virtual register replacement");
          compileUnit.printIt(stdout);
        }
      }
    } catch (SyntaxError e) {
      System.err.println("Syntax error: " + e.msg());
    }
  }
}
