package coins.backend;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.lir.*;

/**
 * LIR type encoder/decoder without instance.
 * Type is represented by an int, not an instance of the class.
 */
public class LType implements Keywords, LirDef {
  private static int TY_TAGWIDTH = 3;
  private static int TY_TAGMASK = ((1 << TY_TAGWIDTH) - 1);

  public static String toString(int type) {
    int bits = type & ~TY_TAGMASK;
    switch (type & TY_TAGMASK) {
    case TY_UNKNOWN:
      return KW_UNKNOWN;
    case TY_INT:
      return "I" + bits;
    case TY_FLOAT:
      return "F" + bits;
    case TY_AGGREGATE:
      return "A" + bits;
    default:
      throw new Error("bad type");
    }
  }

  public int typeTag(int type) {
    return type & TY_TAGMASK;
  }

  public static boolean isAggregate(int type) {
    return (type & TY_TAGMASK) == TY_UNKNOWN;
  }

  public static int decode(String word) throws SyntaxError {
    if (word == KW_UNKNOWN)
      return TY_UNKNOWN;
    else if (word.charAt(0) == 'I') {
      int bits = Integer.parseInt(word.substring(1));
      return TY_INT + ((bits + TY_TAGMASK) & ~TY_TAGMASK);
    }
    else if (word.charAt(0) == 'F') {
      int bits = Integer.parseInt(word.substring(1));
      return TY_FLOAT + ((bits + TY_TAGMASK) & ~TY_TAGMASK);
    }
    else if (word.charAt(0) == 'A') {
      int bits = Integer.parseInt(word.substring(1));
      return TY_AGGREGATE + ((bits + TY_TAGMASK) & ~TY_TAGMASK);
    }
    else
      throw new SyntaxError("Type expected but " + word);
  }
}
