package coins.backend.lir;

import coins.backend.*;

public class LirFconst extends LirNode implements LirDef {
  double value;

  LirFconst(int id, int t, double v) {
    super(id, OP_FLOATCONST, t);
    value = v;
  }

  public String toString() {
    return "(" + OpTable.toName(opCode) + TypePrefix + LType.toString(type)
      + " " + value + ")";
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}

