package coins.backend.lir;

import java.lang.*;
import coins.backend.*;

/** Represents N-ary operators */
public class LirNaryOp extends LirNode implements LirDef {
  LirNode src[];

  LirNaryOp(int id, int op, int t, LirNode operands[]) {
    super(id, op, t);
    src = operands;
  }

  public int nSrcs() { return src.length; }

  public LirNode src(int n) { return src[n]; }

  public void setSrc(int n, LirNode x) { src[n] = x; }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

  public LirNode[] getTargets() {
    LirNode[] targets;
    switch (opCode) {
    case OP_JUMPC:
      targets = new LirNode[2];
      targets[0] = ((LirUnaOp)src[1]).src;
      targets[1] = ((LirUnaOp)src[2]).src;
      return targets;

    case OP_JUMPN:
      LirNaryOp cases = (LirNaryOp)src[1];
      // cases.opCode == OP_LIST
      int n = cases.src.length;
      targets = new LirNode[n + 1];
      for (int i = 0; i < n; i++)
        targets[i] = ((LirUnaOp)((LirBinOp)cases.src[i]).src1).src;
      targets[n] = ((LirUnaOp)src[2]).src;
      return targets;

    default:
      return null;
    }
  }
}

