package coins.backend.tmd;

import coins.backend.tmd.cs.*;

class InitFun {
  private static boolean initialized = false;

  static void init() {
    if (! initialized) {
      Eval.init();

      // % ls *Lisp.java | sed  's/java/init();/'
      LibLisp.init();
      TconcLisp.init();
      QueLisp.init();
      
      Subr.init();
      initialized = true;
    }
  }

  static void load(String csfile, boolean verbose) {
    // $BI,MW$J$i(B init $B$r$7!"(Bcsfile $B$r%m!<%I!#(B
    // $B$3$N;~E@$G(B (load-path) = () $B$J$i$P(B csfile $B$N%G%#%l%/%H%j(B dir
    // $B$h$j(B (dir) $B$H$$$&%m!<%I%Q%9$r%;%C%H!#(B
    init();
    if (IO.load_path() == List.nil) {
      String fullpath = IO.file_absolute_path(csfile);
      IO.load_path_set(LibFun.list(IO.file_name_directory(fullpath)));
    }
    csfile = IO.load_path_search(csfile);
    try {
      if (verbose) System.out.print("Loading "+csfile+" ... ");
      IO.load(csfile,Boolean.FALSE,null);
      if (verbose) System.out.println("done.");
    } catch (Throwable e) {
      LibFun.fatalError(e);
    }
  }

  static void load(String csfile) {
    load(csfile, false);
  }
}
