// (c) Copyright Taiichi Yuasa, 2002.  All rights reserved.

package coins.backend.tmd.cs;

public final class Env {

  private Symbol symbol;
  private Object value;
  private Env next;

  public Env(Symbol sym, Object val, Env env) {
    symbol = sym;
    value = val;
    next = env;
  }

  public static Object vref(Symbol sym, Env env) {
    for (; env != null; env = env.next)
      if (env.symbol == sym)
        return env.value;
    return sym.valueOf();
  }

  public static Function fref(Symbol sym, Env env) {
    for (; env != null; env = env.next)
      if (env.symbol == sym)
        return (Function) env.value;
    return sym.functionOf();
  }

  static { Subr.defSpecial("Env", "vset", "set!", 2, 0, false); }
  public static Object vset(Symbol sym, Object expr, Env env) {
    Object val = Eval.eval(expr, env);
    for (; env != null; env = env.next)
      if (env.symbol == sym)
        return env.value = val;

    return sym.setValue(val);
  }

  static Env lambdaBind(Object params, List args, Env env) {
    while (params instanceof Pair) {
      if (args == List.nil)
        throw Eval.error("too few arguments");
      env = new Env((Symbol) ((Pair) params).car, args.car, env);
      params = ((Pair) params).cdr;
      args = (List) args.cdr;
    }
    if (params != List.nil)
      env = new Env((Symbol) params, args, env);
    else if (args != List.nil)
      throw Eval.error("too many arguments");
    return env;
  }

  static Env recBind(Object val, Env newenv, Env env) {
    Env ep;
    for (ep = newenv; ep.next != env; ep = ep.next) ;
    ep.value = val;
    return ep;
  }

  public static void recBind1(Object val, Env env) {
    env.value = val;
  }

  static void init() {}
}
