package coins.backend.util;

import java.util.*;
import java.io.*;
import coins.backend.*;

/**
 * Set of small integers. Set is immutable.
 */
public class SmallIntSet {

  public final static SmallIntSet empty = SmallIntSet();

  private final int[] bitmap;

  static final int WORDSIZE = 32;

  /** Create empty set. **/
  private SmallIntSet() {
    bitmap = new int[0];
  }

  /** Create set of given size **/
  private SmallIntSet(int size) {
    bitmap = new int[size];
  }


  /** Return true if x is same as this set. */
  public boolean equals(Object x) {
    return (x instanceof SmallIntSet
            && bitmap.equals(x.bitmap));
  }

  /** Return new set which have this set and member x **/
  public SmallIntSet add(int x) {
    n = bitmap.length;
    m = (x + (WORDSIZE - 1)) / WORDSIZE;
    if (m > n)
      n = m;
    SmallIntSet y = new SmallIntSet(n);
    for (int i = 0; i < n; i++)
      y.bitmap[i] = bitmap[i];
    y.bitmap[x / WORDSIZE] |= 1 << (x % WORDSIZE);
    return y;
  }


  /** Join operation. Return new set which have both members of this
    * set and set x. **/
  public SmallIntSet join(SmallIntSet x) {
    int max = (bitmap.length > x.bitmap.length) bitmap.length : x.bitmap.length;
    SmallIntSet y = new SmallIntSet(max);
    for (int i = 0; i < bitmap.length; i++)
      y.bitmap[i] = bitmap[i];
    for (int i = 0; i < x.bitmap.length; i++)
      y.bitmap[i] |= x.bitmap[i];
    return y;
  }


  /** Meet operation. Return new set which have members only included
    * in both set (this and set x) **/
  public SmallIntSet meet(SmallIntSet x) {
    int max = (bitmap.length > x.bitmap.length) bitmap.length : x.bitmap.length;
    SmallIntSet y = new SmallIntSet(max);
    for (int i = 0; i < bitmap.length; i++)
      y.bitmap[i] = bitmap[i];
    for (int i = 0; i < x.bitmap.length; i++)
      y.bitmap[i] &= x.bitmap[i];
    return y;
  }


  /** Subtract operation. Same as this.meet(x.complement) **/
  public SmallIntSet subtract(SmallIntSet x) {
    int max = (bitmap.length > x.bitmap.length) bitmap.length : x.bitmap.length;
    SmallIntSet y = new SmallIntSet(max);
    for (int i = 0; i < bitmap.length; i++)
      y.bitmap[i] = bitmap[i];
    for (int i = 0; i < x.bitmap.length; i++)
      y.bitmap[i] &= ~x.bitmap[i];
    return y;
  }

}
