package coins.backend.sym;

import java.io.*;
import coins.backend.*;

/** Symbol table entry for static objects */
public class SymStatic extends Symbol {
  /** Segment name */
  public final String segment;

  /** Indicates whether external or internal */
  public final String linkage;

  /** Body of the function. */
  Function body;

  /** Create static objects' symbol entry. Only SymTab calls. */
  SymStatic(String name, int id, int storage, int type, int boundary,
            String segment, String linkage) {
    super(name, id, storage, type, boundary);
    this.segment = segment;
    this.linkage = linkage;
  }

  /** Return body */
  public Function body() { return body; }

  /** Set function body */
  public void setBody(Function func) { body = func; }

  /** Visualize */
  public String toString() {
    return "(\"" + name + "\" " + Storage.toString(storage)
      + " " + Type.toString(type)
      + " " + boundary + " " + segment + " " + linkage
      + flagsToString() + ")";
  }
}
