// -*- mode: jde; c-basic-offset: 2 -*-
// Fri Jun 13 20:58:59 JST 2003 
//##19 Modified by Tan 021202

import coins.ir.hir.HIR;
import coins.hir2lir.ConvToNewLIR;

import coins.IoRoot;
import coins.SymRoot;
import coins.IrRoot;
import coins.HirRoot;
import coins.LirRoot;
import coins.FlowRoot;

import coins.driver.CoinsOptions;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.CompilerDriver;
import coins.driver.CompilerImplementation;

import coins.driver.Trace;
import coins.FatalError;
import coins.PassException;

import coins.backend.util.*;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * A driver implementation using the COINS Compiler Driver API.
 * You can totally rewrite your compiler by referring this implementation, or, 
 * extend this class and redefine some methods.
 **/
public class Driver2 extends Driver {

  /**
   *
   * A name in trace messages.  Derived classes can override it.
   **/
  protected String myName = "Driver2";

  /**
   * Compiler.<br>
   *
   * This sample compiler has eight passes:
   * <ol>
   *   <li> C source to HIR-C(*),
   *   <li> HIR-C to HIR-Base(*),
   *   <li> Flow analysis on HIR(*),
   *   <li> Optimization and Parallelization on HIR,
   *   <li> HIR to LIR(*),
   *   <li> LIR Flow Analysis,
   *   <li> Optimization and Parallelization on LIR, and
   *   <li> Assembly code generation.
   * </ol>
   *
   * Five of the above (*) are already implemented.
   *
   * @param sourceFile the source file name.
   * @param in input.
   * @param out output.
   * @param spec the command line options and arguments.
   **/
  public void compile(File sourceFile,
		      InputStream in,
		      OutputStream out,
		      CompileSpecification spec)
    throws IOException, PassException {

    boolean hirAnal = spec.getCoinsOptions().isSet("hirAnal");
    boolean lirAnal = spec.getCoinsOptions().isSet("lirAnal");
    boolean optLab1 = spec.getCoinsOptions().isSet("optLabel1"); //##19
    boolean optLab2 = spec.getCoinsOptions().isSet("optLabel2"); //##19

    Trace trace=spec.getTrace();

    IoRoot io = new IoRoot(sourceFile,
			   System.out, new PrintStream(out),
			   System.err, spec);
    SymRoot symRoot  = new SymRoot(io);
    HirRoot hirRoot  = new HirRoot(symRoot);
    symRoot.attachHirRoot(hirRoot);
    symRoot.initiate();

    /* pass 1 -- AST to HIR-C */
    hirRoot.programRoot = makeHirCFromCSource(hirRoot, in, io);
    trace.trace(myName, 5000, "compile(1)");

    /* check HIR */
    ((HIR) hirRoot.programRoot).print(0, true);

    /* pass 2 -- HIR-C to HIR-Base */
    hirRoot.programRoot
      = makeHirBaseFromC(hirRoot, (HIR)hirRoot.programRoot, io);
    trace.trace(myName, 5000, "compile(2)");
    deleteUselessLabelsOfHir(hirRoot, optLab1, optLab2); //##19
    makeCSourceFromHirBase("new", hirRoot, symRoot, io);
    trace.trace(myName, 5000, "compile(2.5)");

    /* pass 3 -- flow analysis */
    FlowRoot hirFlowRoot;
    if (hirAnal)  //##12
      hirFlowRoot = makeHIRFlowAnalysis(hirRoot, symRoot, io);
    else  //##12
      hirFlowRoot = new FlowRoot(hirRoot); //##12
    trace.trace(myName, 5000, "compile(3)");
    makeCSourceFromHirBase("flo", hirRoot, symRoot, io);
    trace.trace(myName, 5000, "compile(3.5)");

    /* pass 4 -- Optimization & Parallelization in HIR will be here. */
    optimizeHir(hirRoot, hirFlowRoot, symRoot, io);
    trace.trace(myName, 5000, "compile(4)");
    makeCSourceFromHirBase("opt", hirRoot, symRoot, io);
    trace.trace(myName, 5000, "compile(4.5)");

    /* check HIR */
    // ((HIR) hirRoot.programRoot).print(0, true);

    /* convert to new LIR */
    ConvToNewLIR newconvert = new ConvToNewLIR(sourceFile, out, hirRoot);
    ImList sexp = newconvert.doConvert((HIR)hirRoot.programRoot);
    trace.trace(myName, 5000, "hir -> newlir");
    trace.trace(myName, 5000, "lir: " + sexp);

    PrintWriter debOut = new PrintWriter(System.out, true);
    coins.backend.BackEnd cg = new coins.backend.BackEnd(true, debOut);

    try {
      cg.doIt(sexp, out);
    } catch (coins.backend.SyntaxError e) {
      throw new RuntimeException("Syntax error: " + e.getMessage());
    }
  }

  /**
   * A main function.<br>
   *
   * Makes a compile specification from a command line.  Creates an compiler
   * driver API object giving the compile specification.  Creates a driver
   * implementation object and pass it to the API object to start compilation.
   *
   * @param args a command line.
   **/
  public static void main(String[] args) {
    CompileSpecification spec = new CommandLine(args);
    int status = new CompilerDriver(spec).go(new Driver2());
    System.exit(status);
  }
}
