package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.sym.*;

/** Represent LABEL node */
public class LirLabelRef extends LirNode {
  public final Label label;

  public LirLabelRef(int id, int op, int type, Label lab, ImList opt) {
    super(id, op, type, opt);
    label = lab;
  }

  public LirNode makeCopy(LirFactory fac) {
    return this;
  }

  public String toString() {
    return (Debug.showId ? "$"+id+":" : "")
      + "(" + Op.toName(opCode)
      + (type == Type.UNKNOWN ? "" : Debug.TypePrefix + Type.toString(type))
      + " \"" + label + "\")";
  }

  public boolean equals(Object x) {
    return (x instanceof LirLabelRef && super.equals(x)
            && label == ((LirLabelRef)x).label);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
