;;;; TMD $BMQ(B LIR $B$N%$%s%W%j%a%s%H(B

;;; L-$B<0(B $B$N%7%s%\%k$NJ,N`!#(B

(define *lir-syms-itype*
  '(I8 I16 I32 I64 I128))

(define *lir-syms-ftype*
  '(F32 F64 F128))

(define *lir-syms-type*
  (append *lir-syms-itype* *lir-syms-ftype*))

(define *lir-syms-const*
  '(INTCONST FLOATCONST))

(define *lir-syms-addr*
  '(STATIC FRAME LABEL))

(define *lir-syms-reg*
  '(REG SUBREG))

(define *lir-syms-arith*
  '(NEG ADD SUB MUL DIVS DIVU MODS MODU))

(define *lir-syms-conv*
  '(CONVSX CONVZX CONVIT CONVFX CONVFT CONVFI CONVSF CONVUF))

(define *lir-syms-bit*
  '(BAND BOR BXOR BNOT))

(define *lir-syms-shift*
  '(LSHS LSHU RSHS RSHU))

(define *lir-syms-tst*
  '(TSTEQ TSTNE TSTLTS TSTLES TSTGTS TSTGES TSTLTU TSTLEU TSTGTU TSTGEU))

(define *lir-syms-mem*
  '(MEM))

(define *lir-syms-set*
  '(SET))

(define *lir-syms-jump*
  '(JUMP JUMPC JUMPN))

(define *lir-syms-untyped*
  (append *lir-syms-jump*
	  '(DEFLABEL CALL PROLOGUE EPILOGUE PARALLEL USE CLOBBER)))

(define *lir-syms-pure*
  (append *lir-syms-arith*
	  *lir-syms-conv*
	  *lir-syms-bit*
	  *lir-syms-shift*
	  *lir-syms-tst*
	  '(ASMCONST PURE)))

(define *lir-syms-atomic-typed*
  (append *lir-syms-const*
	  *lir-syms-addr*
	  *lir-syms-reg*))

(define *lir-syms-nonatomic-typed*
  (append *lir-syms-pure*
	  *lir-syms-mem*
	  *lir-syms-set*))

(define *lir-syms-typed*
  (append *lir-syms-atomic-typed*
	  *lir-syms-nonatomic-typed*))

;;; predicates

(define (typed-exp? e)
  (memq (exp-code e) *lir-syms-typed*))

(define (untyped-exp? e)
  (memq (exp-code e) *lir-syms-untyped*))

(define (atomic-typed-exp? e)
  (memq (exp-code e) *lir-syms-atomic-typed*))

(define (set-reg-exp? e)
  ;; REG $B$^$?$O(B SUBREG $B$X$NBeF~$+!)(B
  (and (eq? (exp-code e) 'SET)
       (memq (exp-code (car (exp-args* e)))
	     '(REG SUBREG))))


;;; L-$B<0$N:n@.5Z$S%"%/%;%94X?t(B

(define exp-code car)

(define (exp-type e)
  (unless (typed-exp? e) (error "%S is not a typed exp" e))
  (cadr e))

(define (exp-args* e)
  ;; typed $B<0$N0z?t%j%9%H(B($BB0@-$b4^$s$G$7$^$&(B)$B$rJV$9!#(B
  (unless (typed-exp? e) (error "%S is not a typed exp" e))
  (if (atomic-typed-exp? e)
      ()
    (cddr e)))


(define (exp-prop-sym? x)
  ;; & $B$G;O$^$k%7%s%\%k!#(B
  (and (symbol? x)
       (char=? #\& (string-ref (symbol->string x) 0))))

(define (exp-plist e)
  ;; &xxx $BB0@-%j%9%HItJ,$rJV$9!#(B
  (call/cc
   (lambda (return)
     (dolist* (a (cdr e) ())
       (if (exp-prop-sym? (car a))
	   (return a))))))

(define (exp-without-plist e)
  ;; $BItJ,<0$b4^$a!"A4$F$NB0@-$r:o=|$7$?(B L-$B<0$rJV$9!#(B
  ;; $B85$N<0$OGK2u$7$J$$!#(B
  (cond
   ((null? e) e)
   ((not (pair? e)) e)
   ((exp-prop-sym? (car e)) ())
   (else
    (cons (exp-without-plist (car e))
	  (exp-without-plist (cdr e))))))

(define (exp-atomic-typed-arg e)
  (unless (atomic-typed-exp? e) (error "%S is not an atomic typed exp" e))
  (if (eq? (exp-code e) 'SUBREG)
      ;; (SUBREG <Ltype> <SimpleRegExp> <Fixnum>)
      (list (caddr e) (cadddr e))
    (caddr e)))

(define (foreach-exp-args f e)
  ;; typed $B<0$N(B args $B$r%k!<%W!#(B
  (do ((as (exp-args* e) (cdr as)))
      ((or (null? as) (symbol? (car as))) ())
    (funcall f (car as))))

(define (foreach-exp-args* f e)
  ;; typed $B<0$N(B args $B$N(B place $B$r%k!<%W!#(B
  (do ((as (exp-args* e) (cdr as)))
      ((or (null? as) (symbol? (car as))) ())
    (funcall f as)))

(define (foreach-exp-recursive f e)
  ;; typed $B<0$*$h$SItJ,<0$r%H%C%W%@%&%s$K$?$I$k!#(B
  (funcall f e)
  (unless (atomic-typed-exp? e)
    (foreach-exp-args
     (lambda (a) (foreach-exp-recursive f a))
     e)))

(define (map-exp-args f e)
  ;; f $B$r(B typed $B<0$N(B args $B$K(B map$B!#(B
  (let ((tc (make-tconc)))
    (foreach-exp-args
     (lambda (a) (tconc tc (funcall f a)))
     e)
    (tconc->list tc)))

(define (exp-args e)
  ;; typed $B<0$N0z?t%j%9%H$N%3%T!<$rJV$9!#(B
  (map-exp-args identity e))


;;; Symtab $B4X78(B

(define (lookup-symtab symtab name)
  ;; <Symtab> $B$r8!:w$7!"%(%s%H%j!<$N(B cdr ($B0J2<(B sent) $B$rJV$9!#(B
  ;; $B$J$1$l$P(B #f
  (let ((sent (assoc name (cdr symtab))))
    (and sent (cdr sent))))

(define (enter-symtab symtab sent)
  (when (lookup-symtab symtab (car sent))
    (error "%s is already in %s" symtab))
  (nconc symtab (list sent)))

(define (make-reg-sent exp)
  (list (caddr exp) 'REG (cadr exp) 0))
      
(define (sent-type sent)
  (cadr sent))

(define (sent-offset sent)
  (case (car sent)
    ((REG) (caddr sent))
    ((FRAME) (cadddr sent))
    (else (error ""))))


;;; L-$B<0$N:n@.4X?t!#(B

(define (make-typed-exp code type . args)
  (list* code type args))

(define *vreg-counter* 0)

(define (make-vreg-exp type . symtab-opt)
  (let ((exp (make-typed-exp
	      'REG type
	      (format 0 "v%d" (inc! *vreg-counter*)))))
    (unless (null? symtab-opt)
      (enter-symtab (car symtab-opt) (make-reg-sent exp)))
    exp))

(define (reset-vreg-counter)
  (set! *vreg-counter* 0))

(define (make-set-exp x y)
  (make-typed-exp 'SET (exp-type x) x y))
