package coins.backend.lir;

import coins.backend.*;
import coins.backend.util.*;

/**
 * Represent integer constant
 */
public class LirIconst extends LirNode {

  /** Value of this node */
  public final long value;

  public LirIconst(int id, int t, long v, ImList opt) {
    super(id, Op.INTCONST, t, opt);
    value = v;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.iconst(type, value, opt);
  }

  public int hashCode() {
    return (int)(value ^ (value >> 32) ^ type);
  }

  public String toString() {
    return (Debug.showId ? "$"+id+":" : "")
      + "(" + Op.toName(opCode) + Debug.TypePrefix + Type.toString(type)
      + " " + value + ")";
  }

  public boolean equals(Object x) {
    return (x instanceof LirIconst && super.equals(x)
            && value == ((LirIconst)x).value);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
