;;;; main.cs - $B4XO"%U%!%$%k$N%m!<%I$H%G%P%C%0MQ4X?t$NDj5A!#(B

(define *debug*
  ;; $B%G%P%C%0%@%s%W@)8fMQ!#(B() $B$J$i2?$b=P$5$J$$!#(B
  '(instsel
    tmd->tmdr
    tmd-make-reg-nt-alist
    load-tmdr
    ))


(load "lib.cs")
(load "lir.cs")
(load "clir.cs")
(load "tmd.cs")
(load "instsel.cs")
(load "asmout.cs")



;;; $B0J2<$O%F%9%HMQ4X?t!#(B

(define (test-exp tmd exp)
  (reset-vreg-counter)
  (load-tmd tmd)
  (let ((exp (if (string? exp) (clir->slir exp) exp)))
    (format 1 "exp = %S\n" exp)
    (asmout 1 (test-instsel-exp exp))
    ()))

(define (test-lfunc tmd lfunc)
  (reset-vreg-counter)
  (load-tmd tmd)
  (instsel lfunc))


(define *lfunc*
  ;; $B%5%s%W%k(B L-$B4X?t(B
  '(FUNCTION "f"
	     (SYMTAB
	      ("x" REG I32 0)
	      ("y" REG I32 0)
	      ("z" REG I32 0)
	      ("a" FRAME I32 4 0))
	     (PROLOGUE (0 0))
	     
	     ;; "z = *(x+1) + y * a"
	     (SET I32 (REG I32 "z")
		  (ADD I32 (MEM I32 (ADD I32 (REG I32 "x") (INTCONST I32 1)))
		       (MUL I32 (REG I32 "y") (REG I32 "a"))))
	     
	     (EPILOGUE (0 0))))



;; Emacs $B$G$N(B S-$B<0$N(B pretty print $B$O$?$H$($P(B (require 'cl) $B$7$F0J2<$G=PMh$k!#(B
;;
;;        (defun pretty-print ()
;;          ;; $B%+!<%=%k$N$"$k(B S-$B<0$r(B *pretty* $B%P%C%U%!$X(B pretty print$B!#(B
;;          (interactive)
;;          (let ((s (read (current-buffer))))
;;            (with-output-to-temp-buffer "*pretty*"
;;              (set-buffer "*pretty*")
;;              (cl-prettyexpand s))))
