;;; tmd $B%U%!%$%k4X78!#(B

(define (tmd->tmdr tmd . tmdr-opt)
  ;; .tmd $B$r(B .tmdr $B$KJQ49!#(B
  ;; 1. (foreach ...) $B%^%/%m$NE83+!#(B
  ;; 2. (defcode ....) $B$r(B defrule $B$XJQ49!#(B
  ;; 3. (defrule ...) $B$N%G%U%)%k%HItJ,$rJd4V!#(B
  ;; tmdr $B%U%!%$%kL>$rJV$9!#(B
  (let ((tmdr (if (null? tmdr-opt)
		  (file-name-change-suffix tmd ".tmdr")
		tmd))
	(forms ()))
    (when (memq 'tmd->tmdr *debug*)
      (format 1 "Converting %s -> %s ... %" tmd tmdr))
    ;;
    (set! forms (tmd-expand-forms (read-sexps-from-file tmd)))
    (call-with-output-file tmdr
      (lambda (os)
	(dolist (form forms)
	  (format os "%S\n" form))))
    ;;
    (when (memq 'tmd->tmdr *debug*)
      (format 1 "done. (%d rules)\n"
	      (count (lambda (x) (eq? (car x) 'defrule)) forms)))
    ;;
    tmdr))


(define (tmd-expand-forms forms)
  (let* ((forms-rx (tmd-expand-defrule-forms
		    (tmd-expand-defregset-forms
		     (tmd-expand-macro-forms forms))))
	 (reg-nt-alist (tmd-make-reg-nt-alist forms-rx)))
    (tmd-expand-defcode-forms forms-rx reg-nt-alist)))


(define (test-tmd-expand-macro-forms srcf)
  (let ((objf (format 0 "%s.x" srcf))
	(forms (read-sexps-from-file srcf)))
    (call-with-output-file objf
      (lambda (os)
	(dolist (form (tmd-expand-macro-forms forms))
	  (format os "%S\n" form))))))

(define (tmd-expand-macro-forms forms)
  ;; $B!z(B (def xxx ) $B%^%/%m$NDI2C!#(B
  (tmd-expand-foreach-forms forms))

(define (tmd-expand-foreach-forms forms)
  (cond
   ((null? forms) ())
   ((atom? forms) forms)
   ((atom? (car forms))
    (cons (car forms)
	  (tmd-expand-foreach-forms (cdr forms))))
   ((eq? (car (car forms)) 'foreach)
    (let* ((fe (car forms))
	   (vars (cadr fe))
	   (valss (caddr fe))
	   (body (cdddr fe)))
      (append
       (tmd-expand-foreach-forms
	(tmd-expand-foreach-form vars valss body))
       (tmd-expand-foreach-forms (cdr forms)))))
   (else
    (append
     (list (tmd-expand-foreach-forms (car forms)))
     (tmd-expand-foreach-forms (cdr forms))))))

(define (tmd-expand-foreach-form vars valss body)
  ;;
  (define (subst sexp alist)
    (cond
     ((symbol? sexp)
      (let ((a (assq sexp alist)))
	(if a
	    (cadr a)
	  (string->symbol (subst (symbol->string sexp) alist)))))
     ((string? sexp)
      (dolist (a alist)
	(set! sexp (replace-substring
		    sexp
		    (symbol->string (car a))
		    (format 0 "%s" (cadr a)))))
      sexp)
     ((pair? sexp)
      (cons (subst (car sexp) alist)
	    (subst (cdr sexp) alist)))
     (else
      sexp)))
  ;;
  (when (symbol? vars)
    ;; (foreach x (a b c) ...) -> (foreach (x) ((a) (b) (c)) ...)
    (set! vars (list vars))
    (set! valss (map list valss)))
  (let ((ret (make-tconc)))
    (dolist (vals valss)
      (let ((alist (zip-with (lambda (var val) `(,var ,val)) vars vals)))
	(dolist (b body)
	  (tconc ret (subst b alist)))))
    (tconc->list ret)))

(define (tmd-make-reg-nt-alist forms)
  ;; nt $B$+$i%A%'%$%s%k!<%k$N$_$?$I$j(B regset $B%7%s%\%k(B reg1, reg2
  ;; $B$X$?$I$l$k$H$-!"(B
  ;; ((nt reg1 reg2...) ...)
  ;; $B$H$$$&%j%9%H$rJV$9!#(B
  ;; $B!z(B $B$R$H$D$N(B nt $B$K$D$$$F(B regi $B$O0l0U!"$H$$$&2>Dj$,I,MW(B($B%A%'%C%/!*(B)$B!#(B
  (define (chain-alist forms)
    ;; forms $B$O(B defrule $BE83+$^$G=*N;$7$?$b$N!#(B
    ;; $B$3$l$+$i(B Ni:Ni1, Ni:Ni2, ... $B$H$$$&%A%'%$%s%k!<%k$h$j(B
    ;; ((Ni  Ni1 Ni2...) (Nj  Nj1 Nj2...) ...)
    ;; $B$H$$$&(B alist $B$rJV$9!#(B
    (let ((alist ()))
      (dolist (rule forms)
	(when (and (eq? (car rule) 'defrule)
		   (chain-rule? rule))
	  (let ((a (assq (rule-nt rule) alist)))
	    (unless a
	      (set! a (list (rule-nt rule)))
	      (set! alist (cons a alist)))
	    (nconc a (list (rule-pat rule))))))
      alist))
  ;;
  (define (regset-syms forms)
    (map cadr (filter (lambda (f) (eq? (car f) 'defregset)) forms)))
  ;;
  (define (lookup nt alist regsets)
    ;; nt $B$+$i$?$I$l$k(B regset sym $B$N%j%9%H$rJV$9!#(B
    ;; $B!z(B .tmd $B$N(B defrule $B$G$O(B nt $B$N%k!<%W$O$J$$$H2>Dj(B...
    (let ((ret ()))
      (dolist (r (cdr (or (assq nt alist) ())))
	(if (memq r regsets)
	    (set! ret (append ret (list r)))
	  (set! ret (append ret (lookup r alist regsets)))))
      ret))
  ;;
  (let* ((regsets (regset-syms forms))
	 (chain-alist (chain-alist forms))
	 (reg-nt-alist (map (lambda (a)
			      (cons (car a)
				    (lookup (car a) chain-alist regsets)))
			    chain-alist)))
    (when (memq 'tmd-make-reg-nt-alist *debug*)
      (format 1 "\n")
      (format 1 "\tregsets      = %S\n" regsets)
      (format 1 "\tchain-alist  = %S\n" chain-alist)
      (format 1 "\treg-nt-alist = %S\n" reg-nt-alist))
    ;;
    reg-nt-alist))


(define (tmd-expand-defregset-forms forms)
  forms)

(define (tmd-expand-defcode-forms forms reg-nt-alist)
  (let ((ret (make-tconc))
	(names ()))
    (dolist (f forms)
      (case (car f)
	((defcode)
	 (let* ((name (cadr f))
		(pat (caddr f))
		(misc (tmd-expand-misc (cdddr f))))
	   ;;
	   (if (memq name names)
	       (error "duplicated defcode name: %s\n" name)
	     (set! names (cons name names)))
	   ;;
	   (tconc ret
		  `(defrule
		     (stmt
		      ,(string->symbol (format 0 "%s.stmt" name)))
		     ,pat
		     ,@misc))
	   ;;
	   (when (eq? (car pat) 'SET)
	     (let ((a (assq (car (exp-args* pat)) reg-nt-alist)))
	       (when a
		 (tconc ret
			`(defrule
			   (,(cadr a)
			    ,(string->symbol (format 0 "%s.reg" name)))
			   ,(cadddr pat)
			   ,@(filter (lambda (x)
				       ;; defcode $B$+$i$D$/$i$l$?$3$N(B rule $B$G$O(B
				       ;; (asm ...) $B$O;2>H$5$l$J$$$N$G%+%C%H!#(B
				       (not (eq? (car x) 'asm)))
				     misc)
			   )))))))
	;;
	(else
	 (tconc ret f))))
    ;;
    (tconc->list ret)))


(define (tmd-expand-defrule-forms forms)
  ;; defrule $B$r@55,2=$7!"(B
  ;; (forms alist) $B$rJV$9!#(B
  ;; $B$3$3$K(B forms $B$O(B defrule $B$,@55,2=$5$l$?$b$N!"(B
  ;; alist $B$O(B ((nt-left nt-right1 nt-right2 ...) ...) $B$H$$$&%j%9%H!#(B
  (let ((ret (make-tconc))
	(ntno-alist (list (list 'stmt 0))))
    (dolist (f forms)
      (case (car f)
	((defrule)
	 (tconc ret (tmd-expand-defrule f ntno-alist)))
	(else
	 (tconc ret f))))
    (tconc->list ret)))

(define (tmd-expand-defrule rule ntno-alist)
  (define (default-name nt)
    (let ((a (assq nt ntno-alist)))
      (unless a
	(set! a (list nt 0))
	(nconc ntno-alist (list a)))
      (set-car! (cdr a) (1+ (cadr a)))
      (string->symbol (format 0 "%s.%d" nt (cadr a)))))
  ;;
  (let ((nt-name (cadr rule))
	(pat (caddr rule))
	(misc (tmd-expand-misc (cdddr rule))))
    (when (symbol? nt-name)
      (set! nt-name `(,nt-name ,(default-name nt-name))))
    `(defrule ,nt-name ,pat ,@misc)))

(define (tmd-expand-misc misc)
  (map (lambda (m)
	 (case (car m)
	   ((asm)
	    (tmd-expand-asm m))
	   ((cost)
	    (tmd-expand-cost m))
	   ((cond)
	    (tmd-expand-cond m))
	   (else
	    m)))
       misc))

(define (tmd-expand-asm m)
  ;; m = (asm <asmout>)
  (let ((asm (cadr m)))
    `(asm ,(if (string? asm)
	       (tmd-expand-asm-string asm)
	     asm))))

(define (tmd-expand-asm-string asms)
  ;; e.g.: "mov $1,$2" -> (format 0 "mov %s,%s" $1 $2)
  (let ((is (open-input-string asms))
	(os (open-output-string))
	(vs (make-tconc))
	(c ()))
    (while (not (eof-object? (set! c (read-char is))))
      (case c
	((#\$)
	 (tconc vs (read-char is))
	 (display "%s" os))
	(else
	 (write-char c os))))
    `(format 0 ,(get-output-string os)
	     ,@(map string->symbol
		    (map (lambda (c) (format 0 "$%c" c))
			 (tconc->list vs))))))

(define (tmd-expand-cost m)
  m)

(define (tmd-expand-cond m)
  m)


;; (define (tmd-dec-$s sexp)
;;   ;; sexp $BCf$N(B $n $B$r(B $n-1 $B$K!#(B
;;   (define (subst sexp)
;;     (if (atom? sexp)
;;         (if (symbol? sexp)
;;             (let ((strl (string->list (symbol->string sexp))))
;;               (if (eq? (car strl) #\$)
;;                   (let ((n (string->number (list->string (cdr strl)))))
;;                     (string->symbol (format 0 "$%d" (1- n))))
;;                 sexp))
;;           sexp)
;;       (cons (subst (car sexp))
;;             (subst (cdr sexp)))))
;;   (subst sexp))


(define (load-tmdr tmdr)
  (call-with-input-file tmdr
    (lambda (sm)
      (when (memq 'load-tmdr *debug*)
	(format 1 "Loading %s ... %" tmdr))
      (defrule-load-begin)
      (let ((sexp ()))
	(while (not (eof-object? (set! sexp (read sm))))
	  (case (car sexp)
	    ((defregset) (defregset-load-eval sexp))
	    ((defrule) (defrule-load-eval sexp))
	    (else (eval sexp)))))
      (defrule-load-end)
      (when (memq 'load-tmdr *debug*)
	(format 1 "done.\n")))))


(define (load-tmd tmd)
  (load-tmdr (tmd->tmdr tmd)))


;;; $B0J2<$O(B java $B$N(B TMD $B%/%i%9$N$?$a$N%$%s%?%U%'!<%9!#(B

(define (TMD-new tmd)
  (load-tmd tmd))

(define (TMD-params varname)
  "")

(define (TMD-restra lfunc)
  lfunc)

(define (TMD-instsel lfunc)
  (format 0 "%S" (instsel (reads lfunc))))

(define (TMD-asmout lfunc)
  ())
