package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.cfg.*;

/** Represents DEFLABEL node */
public class LirDefLabel extends LirNode implements LirDef {
  String name;
  BasicBlk basicBlk;

  LirDefLabel(int id, String label) {
    super(id, OP_DEFLABEL, TY_UNKNOWN);
    name = label;
  }

  public String toString() {
    return "(" + OpTable.toName(opCode) + " \"" + name + "\")";
  }

  /** Accept visitor v */
  public void accept(LirVisitor v) {
    v.visit(this);
  }

  // LirDefLabel's own entries
  /** Return label name. */
  public String name() { return name; }

  /** Return basic block which this node belongs to. */
  public BasicBlk basicBlk() { return basicBlk; }

  /** Set basic block which this node belongs to. */ 
  public void setBasicBlk(BasicBlk blk) { basicBlk = blk; }

}

