package coins.backend.lir;

import coins.backend.*;

/** Represents unary operators */
public class LirUnaOp extends LirNode implements LirDef {
  LirNode src;

  LirUnaOp(int id, int op, int t, LirNode operand) {
    super(id, op, t);
    src = operand;
  }

  public int nSrcs() { return 1; }

  public LirNode src(int n) {
    if (n == 0)
      return src;
    else
      throw new IllegalArgumentException();
  }

  public void setSrc(int n, LirNode x) {
    if (n == 0)
      src = x;
    else
      throw new IllegalArgumentException();
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

  public LirNode[] getTargets() {
    if (opCode == OP_JUMP) {
      LirNode[] targets = new LirNode[1];
      targets[0] = ((LirUnaOp)src).src;
      return targets;
    }
    return null;
  }
}

