package coins.backend.opt;

import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.lir.*;
import coins.backend.cfg.*;
import coins.backend.sym.*;

/** Virtual Register Replacement */
public class IntroVirReg implements LirDef {
  private PrintWriter output;

  /** Register name counter */
  int rnctr = 1;

  public IntroVirReg(PrintWriter out) {
    output = out;
  }

  private String newRegName() {
    return "t" + rnctr++;
  }

  private boolean isregistertype(int type) {
    return type == TY_INT + 32 || type == TY_INT + 16;
  }

  public void apply(Module mod) {
    for (BiLink p = mod.functionList.first(); !p.atEnd(); p = p.next()) {
      apply((Function)p.elem());
    }
  }

  private void apply(Function f) {

    LirVisitor v = new LirVisitor() {
        int lastOp = 0;

        public void visit(LirDefLabel node) {}
        public void visit(LirFconst node) {}
        public void visit(LirIconst node) {}
        public void visit(LirPhi node) {}

        public void visit(LirSymRef node) {
          if (node.opCode == OP_FRAME) {
            SymAuto sym = (SymAuto)node.symbol;
            if (lastOp != OP_MEM)
              sym.setFlag(Symbol.F_ADDRESSED, true);
          }
        }

        public void visit(LirUnaOp node) {
          if (node.opCode == OP_LABEL)
            return;
          lastOp = node.opCode;
          node.src(0).accept(this);
        }

        public void visit(LirBinOp node) {
          lastOp = node.opCode;
          node.src(0).accept(this);
          lastOp = node.opCode;
          node.src(1).accept(this);
        }

        public void visit(LirNaryOp node) {
          int n = node.nSrcs();
          for (int i = 0; i < n; i++) {
            lastOp = node.opCode;
            node.src(i).accept(this);
          }
        }
      };
    
    // Mark address taken variables
    for (BiLink p = f.flowGraph.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();
      for (BiLink q = blk.instrList().first(); !q.atEnd(); q = q.next()) {
        LirNode stmt = (LirNode)q.elem();
        stmt.accept(v);
      }
    }

    // Allocate virtual registers
    for (Iterator it = f.localSymtab.iterator(); it.hasNext(); ) {
      Symbol var = (Symbol)it.next();
      if (var.storage == ST_FRAME && !var.testFlag(Symbol.F_ADDRESSED)
          && isregistertype(var.type)) {
        String name = newRegName().intern();
        Symbol reg = f.localSymtab.addSymbol(name, ST_REG, var.type, 0, 0);
        var.setShadow(reg);
        reg.setShadow(var);
      }
    }

    // Replace (REG "tXXX") for (MEM (FRAME "xxx"))
    for (BiLink p = f.flowGraph.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();
      for (BiLink q = blk.instrList().first(); !q.atEnd(); q = q.next()) {
        LirNode stmt = (LirNode)q.elem();
        replaceAll(stmt, f);
      }
    }
  }

  private LirNode replaceAll(LirNode node, Function f) {
    if (node.opCode == OP_LABEL)
      return node;
    if (node.opCode == OP_MEM) {
      LirNode mem = node.src(0);
      if (mem.opCode == OP_FRAME) {
        Symbol var = ((LirSymRef)mem).symbol;
        Symbol reg = var.shadow();
        if (reg != null)
          return f.newLir.symRef(OP_REG, reg.type, reg);
      }
    }
    int n = node.nSrcs();
    for (int i = 0; i < n; i++) {
      LirNode oldsrc = node.src(i);
      LirNode newsrc = replaceAll(oldsrc, f);
      if (newsrc != oldsrc)
        node.setSrc(i, newsrc);
    }
    return node;
  }


}
