package coins.backend.sym;

import java.io.*;
import coins.backend.*;

/** Symbol table entry for automatic objects */
public class SymAuto extends Symbol {
  /** Offset of the FRAME object */
  public final int offset;

  /** Create automatic objects' symbol entry. Only SymTab calls. */
  SymAuto(String aName, int aStorage, int aType, int aBoundary,
          int anOffset) {
    super(aName, aStorage, aType, aBoundary);
    offset = anOffset;
  }

  /** Visualize */
  public String toString() {
    return "(\"" + name + "\" " + LStorage.toString(storage)
      + " " + LType.toString(type) + " " + boundary + " " + offset
      + (flags != 0 ? " &" + flags : "")
      + (shadow != null ? " &shadow=\"" + shadow.name + "\"" : "")
      + ")";
  }
}
