package coins.backend.lir;

import coins.backend.*;

/**
 * Represent integer constant
 */
public class LirIconst extends LirNode {

  /** Value of this node */
  public final int value;

  LirIconst(int id, int t, int v) {
    super(id, Op.INTCONST, t);
    value = v;
  }

  public String toString() {
    return "(" + Op.toName(opCode) + Debug.TypePrefix + Type.toString(type)
      + " " + value + ")";
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
