package coins.backend.lir;

import coins.backend.*;
import coins.backend.sym.*;

/** Represents unary operators */
public class LirUnaOp extends LirNode {
  LirNode src;

  LirUnaOp(int id, int op, int t, LirNode operand) {
    super(id, op, t);
    src = operand;
  }

  public int nSrcs() { return 1; }

  public LirNode src(int n) {
    if (n == 0)
      return src;
    else
      throw new IllegalArgumentException();
  }

  public void setSrc(int n, LirNode x) {
    if (n == 0)
      src = x;
    else
      throw new IllegalArgumentException();
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

  public Label[] getTargets() {
    if (opCode == Op.JUMP) {
      Label[] targets = new Label[1];
      targets[0] = ((LirLabelRef)src).label;
      return targets;
    }
    return null;
  }
}

