#include <stdio.h>

void printd(int n)
{
	if (n < 0) {
		putchar('-');
		n = -n;
	}
	if (n / 10)
		printd(n / 10);
	putchar(n % 10 + '0');
}

void qsort(int v[], int left, int right)
{
	int i, last;
	void swap(int v[], int i, int j);

	if (left >= right)
		return;
	swap(v, left, (left + right)/2);
	last = left;
	for (i = left+1; i <= right; i++)
		if (v[i] < v[left])
			swap(v, ++last, i);
	swap(v, left, last);
	qsort(v, left, last-1);
	qsort(v, last+1, right);
}

void swap(int v[], int i, int j)
{
	int temp;

	temp = v[i];
	v[i] = v[j];
	v[j] = temp;
}

#define SIZE (sizeof(data)/sizeof(int))

main()
{
	int data[] = {4,-2,2,3,-4,-1,0,1,-5,5,-3};
	int i;
	
	qsort(data, 0, SIZE-1);
	for (i = 0; i < SIZE; i++)
		printd(data[i]);
	puts("");
}
