/*
 * JostarDriver.java
 * 
 * Copyright 2023 dhrname <dhrname@jostar.jp>
 * 
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
 * 
 * 
 */

package jostarfront;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;

import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.driver.Driver;
import coins.driver.Suffix;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.Trace;
import coins.ir.hir.Program;
import jostarfront.JostarParser;


public class JostarDriver extends Driver {
	
	public static void main (String[] args) {
		new JostarDriver().go(args);
	}
    
    protected void makeHirFromSource(File sourceFile, 
        HirRoot hirRoot,
        Suffix suffix,
        InputStream in,
        IoRoot io)
    throws IOException, PassException {
        JostarParser parser = new JostarParser(io.symRoot, hirRoot, io,
            new FileReader(sourceFile) );
        try {
            parser.program();
            ( (Program)hirRoot.programRoot ).finishHir();
        } catch (Exception e) {
            io.msgError.put( "in Jostar parser: ");
            e.printStackTrace();
        }
    }
}

