// DO NOT EDIT THIS FILE DIRECTLY; Edit Op.pattern instead.
package coins.backend;

import java.lang.*;
import java.util.*;
import coins.backend.*;

/** Operator mnemonic encoder/decoder.
 *   operator mnemonic are represented in int, not an instance of the class. */
public class Op {
  public static final int INTCONST = 1;
  public static final int FLOATCONST = 2;
  public static final int STATIC = 3;
  public static final int FRAME = 4;
  public static final int REG = 5;
  public static final int SUBREG = 6;
  public static final int LABEL = 7;
  public static final int NEG = 8;
  public static final int ADD = 9;
  public static final int SUB = 10;
  public static final int MUL = 11;
  public static final int DIVS = 12;
  public static final int DIVU = 13;
  public static final int MODS = 14;
  public static final int MODU = 15;
  public static final int CONVSX = 16;
  public static final int CONVZX = 17;
  public static final int CONVIT = 18;
  public static final int CONVFX = 19;
  public static final int CONVFT = 20;
  public static final int CONVFI = 21;
  public static final int CONVSF = 22;
  public static final int CONVUF = 23;
  public static final int BAND = 24;
  public static final int BOR = 25;
  public static final int BXOR = 26;
  public static final int BNOT = 27;
  public static final int LSHS = 28;
  public static final int LSHU = 29;
  public static final int RSHS = 30;
  public static final int RSHU = 31;
  public static final int TSTEQ = 32;
  public static final int TSTNE = 33;
  public static final int TSTLTS = 34;
  public static final int TSTLES = 35;
  public static final int TSTGTS = 36;
  public static final int TSTGES = 37;
  public static final int TSTLTU = 38;
  public static final int TSTLEU = 39;
  public static final int TSTGTU = 40;
  public static final int TSTGEU = 41;
  public static final int ASMCONST = 42;
  public static final int PURE = 43;
  public static final int MEM = 44;
  public static final int SET = 45;
  public static final int JUMP = 46;
  public static final int JUMPC = 47;
  public static final int JUMPN = 48;
  public static final int DEFLABEL = 49;
  public static final int CALL = 50;
  public static final int PROLOGUE = 51;
  public static final int EPILOGUE = 52;
  public static final int PARALLEL = 53;
  public static final int USE = 54;
  public static final int CLOBBER = 55;
  public static final int PHI = 56;
  public static final int LIST = 57;
  public static final int UNDEFINED = 58;

  public static final int MAX = 59;
  static String[] opNames = {
    "dummy",
    "INTCONST",
    "FLOATCONST",
    "STATIC",
    "FRAME",
    "REG",
    "SUBREG",
    "LABEL",
    "NEG",
    "ADD",
    "SUB",
    "MUL",
    "DIVS",
    "DIVU",
    "MODS",
    "MODU",
    "CONVSX",
    "CONVZX",
    "CONVIT",
    "CONVFX",
    "CONVFT",
    "CONVFI",
    "CONVSF",
    "CONVUF",
    "BAND",
    "BOR",
    "BXOR",
    "BNOT",
    "LSHS",
    "LSHU",
    "RSHS",
    "RSHU",
    "TSTEQ",
    "TSTNE",
    "TSTLTS",
    "TSTLES",
    "TSTGTS",
    "TSTGES",
    "TSTLTU",
    "TSTLEU",
    "TSTGTU",
    "TSTGEU",
    "ASMCONST",
    "PURE",
    "MEM",
    "SET",
    "JUMP",
    "JUMPC",
    "JUMPN",
    "DEFLABEL",
    "CALL",
    "PROLOGUE",
    "EPILOGUE",
    "PARALLEL",
    "USE",
    "CLOBBER",
    "PHI",
    "LIST",
    "UNDEFINED",

  };

  private static final Map table;

  // Inhibit invokation of constructor.
  private Op() {}

  static {
    // initialize name table
    table = new HashMap();
    for (int i = 0; i < Op.MAX; i++)
      table.put(opNames[i], new Integer(i));
  }

  /** Convert operator mnemonic to integer code */
  public static int toCode(String name) {
    Integer code = (Integer)table.get(name);
    if (code == null)
      throw new Error("Unknown opcode: " + name);
    return code.intValue();
  }

  /** Convert operator code to mnemonic */
  public static String toName(int code) {
    return opNames[code];
  }

}
