package coins.backend.lir;

import coins.backend.*;

/** Represent FLOATCONST node. */
public class LirFconst extends LirNode {
  public final double value;

  LirFconst(int id, int t, double v) {
    super(id, Op.FLOATCONST, t);
    value = v;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.fconst(type, value);
  }

  public String toString() {
    return "(" + Op.toName(opCode) + Debug.TypePrefix + Type.toString(type)
      + " " + value + ")";
  }

  public boolean equals(LirNode x) {
    return (x instanceof LirFconst && super.equals(x)
            && value == ((LirFconst)x).value);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}

