package coins.backend.lir;

import coins.backend.*;

/**
 * Represent integer constant
 */
public class LirIconst extends LirNode {

  /** Value of this node */
  public final long value;

  LirIconst(int id, int t, long v) {
    super(id, Op.INTCONST, t);
    value = v;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.iconst(type, value);
  }

  public String toString() {
    return "(" + Op.toName(opCode) + Debug.TypePrefix + Type.toString(type)
      + " " + value + ")";
  }

  public boolean equals(LirNode x) {
    return (x instanceof LirIconst && super.equals(x)
            && value == ((LirIconst)x).value);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
