package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.sym.*;

/** Represent LABEL/DEFLABEL node */
public class LirLabelRef extends LirNode {
  public final Label label;

  LirLabelRef(int id, int op, int type, Label lab) {
    super(id, op, type);
    label = lab;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.labelRef(opCode, type, label);
  }

  public String toString() {
    return "(" + Op.toName(opCode)
      + (type == Type.UNKNOWN ? "" : Debug.TypePrefix + Type.toString(type))
      + " \"" + label + "\")";
  }

  public boolean equals(LirNode x) {
    return (x instanceof LirLabelRef && super.equals(x)
            && label == ((LirLabelRef)x).label);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
