package coins.backend.lir;

import java.lang.*;
import coins.backend.*;
import coins.backend.sym.*;

/** Represents N-ary operators */
public class LirNaryOp extends LirNode {
  LirNode[] src;

  LirNaryOp(int id, int op, int t, LirNode operands[]) {
    super(id, op, t);
    src = operands;
  }

  public LirNode makeCopy(LirFactory fac) {
    LirNode[] newsrc = new LirNode[src.length];
    for (int i = 0; i < src.length; i++)
      newsrc[i] = src[i].makeCopy(fac);
    return fac.operator(opCode, type, newsrc);
  }

  public int nSrcs() { return src.length; }

  public LirNode src(int n) { return src[n]; }

  public void setSrc(int n, LirNode x) { src[n] = x; }

  public boolean equals(LirNode x) {
    if (!(x instanceof LirNaryOp) || !super.equals(x)
        || src.length != ((LirNaryOp)x).src.length)
      return false;
    for (int i = 0; i < src.length; i++)
      if (src[i].equals(((LirNaryOp)x).src[i]))
        return false;
    return true;
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

  public Label[] getTargets() {
    Label[] targets;
    switch (opCode) {
    case Op.JUMPC:
      targets = new Label[2];
      targets[0] = ((LirLabelRef)src[1]).label;
      targets[1] = ((LirLabelRef)src[2]).label;
      return targets;

    case Op.JUMPN:
      LirNaryOp cases = (LirNaryOp)src[1];
      // cases.opCode == Op.LIST
      int n = cases.src.length;
      targets = new Label[n + 1];
      for (int i = 0; i < n; i++)
        targets[i] = ((LirLabelRef)((LirBinOp)cases.src[i]).src1).label;
      targets[n] = ((LirLabelRef)src[2]).label;
      return targets;

    default:
      return null;
    }
  }

  public void replaceLabel(Label x, Label y, LirFactory fac) {
    switch (opCode) {
    case Op.JUMPC:
      if (((LirLabelRef)src[1]).label.basicBlk().label() == x)
        src[1] = fac.labelRef(Op.LABEL, Type.ADDRESS, y);
      if (((LirLabelRef)src[2]).label.basicBlk().label() == x)
        src[2] = fac.labelRef(Op.LABEL, Type.ADDRESS, y);
      break;

    case Op.JUMPN:
      LirNaryOp cases = (LirNaryOp)src[1];
      int n = cases.src.length;
      for (int i = 0; i < n; i++) {
        if (((LirLabelRef)((LirBinOp)cases.src[i]).src1).label.basicBlk().label() == x)
          ((LirBinOp)cases.src[i]).src1 = fac.labelRef(Op.LABEL, Type.ADDRESS, y);
      }
      if (((LirLabelRef)src[2]).label.basicBlk().label() == x)
        src[2] = fac.labelRef(Op.LABEL, Type.ADDRESS, y);
      break;

    default:
      throw new IllegalArgumentException();
    }
  }
}

