package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.sym.*;

/** SUBREG LirNode */
public class LirSubReg extends LirNode {
  LirNode src;
  public final int pos;

  LirSubReg(int id, int op, int t, LirNode src, int pos) {
    super(id, op, t);
    this.src = src;
    this.pos = pos;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.subReg(opCode, type, src.makeCopy(fac), pos);
  }

  public int nSrcs() { return 1; }

  public LirNode src(int n) {
    if (n == 0)
      return src;
    else
      throw new IllegalArgumentException();
  }

  public void setSrc(int n, LirNode x) {
    if (n == 0)
      src = x;
    else
      throw new IllegalArgumentException();
  }

  public String toString() {
    return "(" + Op.toName(opCode)
      + Debug.TypePrefix + Type.toString(type)
      + " " + src + " " + pos + ")";
  }

  public boolean equals(LirNode x) {
    return (x instanceof LirSubReg && super.equals(x)
            && src.equals(((LirSubReg)x).src) && pos == ((LirSubReg)x).pos);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
