package coins.backend.lir;

import coins.backend.*;
import coins.backend.sym.*;

/** Represents unary operators */
public class LirUnaOp extends LirNode {
  LirNode src;

  LirUnaOp(int id, int op, int t, LirNode operand) {
    super(id, op, t);
    src = operand;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.operator(opCode, type, src.makeCopy(fac));
  }

  public int nSrcs() { return 1; }

  public LirNode src(int n) {
    if (n == 0)
      return src;
    else
      throw new IllegalArgumentException();
  }

  public void setSrc(int n, LirNode x) {
    if (n == 0)
      src = x;
    else
      throw new IllegalArgumentException();
  }

  public boolean equals(LirNode x) {
    return (x instanceof LirUnaOp && super.equals(x)
            && src.equals(((LirUnaOp)x).src));
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

  public Label[] getTargets() {
    if (opCode == Op.JUMP) {
      Label[] targets = new Label[1];
      targets[0] = ((LirLabelRef)src).label;
      return targets;
    }
    return null;
  }

  public void replaceLabel(Label x, Label y, LirFactory fac) {
    if (!(opCode == Op.JUMP))
      throw new IllegalArgumentException();
    if (!(((LirLabelRef)src).label.basicBlk().label() == x))
      throw new IllegalArgumentException();
    src = fac.labelRef(Op.LABEL, Type.ADDRESS, y);
  }

}

