#!/usr/bin/perl

if (@ARGV == 0) {
    die "Usage: gen_profile_data.pl sourcefile.c...\n";
}

$n = 0;
foreach my $f (@ARGV) {
    $f =~ s/^(.*)\.([^.]*)$/\1.prf/;
    open INPUT,$f or die "$f: $!";
    while (<INPUT>) {
	chomp;
	if (/^\#\s*name:\s*(\S+)\s*$/) {
	    $vecname[$n] = $1;
	}
	elsif (/^\#\s*size:\s*\d+\s*\*\s*(\d+)\s*$/) {
	    $vecsize[$n] = $1;
	}
	elsif (/^\s*\d+/) {
	    ;
	}
    }
    print "COUNTER_TYPE ",$vecname[$n],"[",$vecsize[$n],"];\n";
    close INPUT;
    $n++;
}

print "char *__counter_names[] = {\n";
for ($i = 0; $i < $n; $i++) {
    $name = $ARGV[$i];
    print "  \"$name\",\n";
}
print " 0 };\n";

print "COUNTER_TYPE *__counter_vectors[] = {\n";
for ($i = 0; $i < $n; $i++) {
    print "  $vecname[$i],\n";
}
print " 0 };\n";
print "int __countersizes[] = {\n";
for ($i = 0; $i < $n; $i++) {
    print "  $vecsize[$i],\n";
}
print "  -1 };\n";

