#!/usr/bin/perl

$PROF_COUNTS = "profile_data";

# prepare line counts
sub counts {
    my ($s) = @_;
    $s =~ s/^(.*)\.([^.]*)$/\1.prf/;
    %Count = ();
    open POS, $s or die "$s: $!";
    open COUNT, $PROF_COUNTS or die "$PROF_COUNTS: $!";
    while (<COUNT>) {
	chomp;
	last if (/^\#\s*(\S+)\s*$/ && $1 eq $s);
    }
    while (<POS>) {
	chomp;
	if (/^\#/) {
	    ;
	}
	elsif (/^\s*(\d+)/) {
	    $linenums = $_;
	    my $c = <COUNT>;
	    chomp $c;
	    if ($c =~ /^\s*(\d+)/) {
		$counts = $1;
		while ($linenums =~ /^\s*(\d+)/) {
		    $Count{$1} = $counts if $Count{$1} == '';
		    $linenums =~ s/^\s*\d+//;
		}
	    }
	}
    }
    close COUNT;
    close POS;
}

if (@ARGV == 0) {
    die "Usage: prof_list.pl source.c...\n";
}

foreach my $source (@ARGV) {
    counts($source);
    open INPUT, $source or die "$source: $!";
    $linenum = 1;
    while (<INPUT>) {
	chomp;
	if ($Count{$linenum} ne '') {
	    printf "%5d:%7d\t%s\n", $linenum, $Count{$linenum}, $_, 
	} else {
	    printf "%5d:       \t%s\n", $linenum, $_;
	}
	$linenum++;
    }
    close INPUT;
}
