/* ---------------------------------------------------------------------
%   Copyright (C) 2007 Association for the COINS Compiler Infrastructure
%       (Read COPYING for detailed information.)
--------------------------------------------------------------------- */
package coins.util;

/**
 * Ƥӥå(Ѥͥ饹).
 * 黻ǳʬͤΤ줾ΥӥåȤɽ
 * 黻Ҥη̤ƤӥåȤꤵ줿Ȥˡ
 * ƥڥɤƤӥåȤɤΤ褦³뤫᥽åɤ󶡤롣
 * Ⱦ;Ǥϡ0㳰뤫ɤ̤ΰȤߤʤƤ뤿ᡢ
 * ӥåȤ0ɤ˱ƶΤǡƤ뤳Ȥˤʤ롣
 * ξ硢0ʤӥåȤϻǤ뤳Ȥˤʤ롣
 */
public final class IntLive {

// field

// (ƤӥåȤ1ǤӥåȤ0)
  private final IntConst val;

// member type

// եȱ黻Ҥδؿ֥
  private abstract static class Shift {
    abstract IntConst eval(IntConst c,int n);
  }
  private static Shift SHIFT_LSH=new Shift() {
    IntConst eval(IntConst c,int n) { return c.lsh(n); }
  };
  private static Shift SHIFT_RSHU=new Shift() {
    IntConst eval(IntConst c,int n) { return c.rshu(n); }
  };
  private static Shift SHIFT_RSHS=new Shift() {
    IntConst eval(IntConst c,int n) { return c.rshs(n); }
  };

// constructor

  private IntLive(IntConst val) { this.val=val; }

// factory method

/** ꤵ줿ӥåȿ٤ƤƤIntLive֤.
 * @exception IllegalArgumentException ӥåȿǤʤ */
  public static IntLive valueOf(int size) { return new IntLive(IntConst.valueOf(size,0).bnot()); }
/** ꤵ줿ӥåȿ٤ƤǤIntLive֤.
 * @exception IllegalArgumentException ӥåȿǤʤ */
  public static IntLive empty(int size) { return new IntLive(IntConst.valueOf(size,0)); }
/** ꤵ줿ΩäƤӥåȤƤIntLive֤. */
  public static IntLive valueOf(IntConst val) { return new IntLive(val); }

// method

/** ꤵ줿IntLiveȤιʻ֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿IntLiveΥӥåȿۤʤ */
  public IntLive union(IntLive l) { return valueOf(val.bor(l.val)); }
/** ꤵ줿IntLiveȤζʬ֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿IntLiveΥӥåȿۤʤ */
  public IntLive intersection(IntLive l) { return valueOf(val.band(l.val)); }
/** ûξդ³IntLive֤. */
  public IntLive inheritAdd() {
    // ƤӥåȤ겼̤Ϥ٤Ƥ
    return valueOf(propagateRight(val));
  }
/** ûΰդꤵ줿ΤȤ¾դ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritAdd(IntConst c) {
    // cκǲ̤1겼ǤϡƤӥåȤΤޤ³
    // cκǲ̤1ʾǤϡƤӥåȰʲϤ٤Ƥ
    // :
    // 01000010 ¤Ƥӥå
    // 00101000 
    // 01111010 ³Ƥӥå
    return valueOf(propagateRight(val).band(rightmostOne(c).neg()).bor(val));
  }
/** κդ³IntLive֤. */
  public IntLive inheritSub0() { return inheritAdd(); }
/** αդ³IntLive֤. */
  public IntLive inheritSub1() { return inheritAdd(); }
/** αդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritSub0(IntConst c1) { return inheritAdd(c1.neg()); }
/** κդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritSub1(IntConst c0) {
    // x-y~(x-y)ƤӥåȤ˴ؤƱǤ뤳Ȥ
    // ~(x-y) = y-x-1 = (-x-1)+y = ~x+y
    return inheritAdd(c0.bnot());
  }
/** 軻ξդ³IntLive֤. */
  public IntLive inheritMul() { return inheritAdd(); }
/** 軻ΰդꤵ줿ΤȤ¾դ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritMul(IntConst c) {
    if(c.size()!=val.size()) throw new IllegalArgumentException(this+" "+c);
    if(c.signum()==0) return empty(val.size());
    IntConst a=rightmostOne(c);
    IntConst v0=val.divu(a);
    if(a.equals(c)) return valueOf(v0); // c2Τ٤ʤ饷եȤƱ
    // cǲ̤1ӥåiǡ2ܤ1ӥåi+jȤȡѤϡ
    //  ӥå0i-1ޤǤϾ0
    //  ӥåii+j-1ޤǤΥӥå0j-1ޤǤΤޤ
    //  ӥåi+j+k(k>=0)ǤϡΥӥå0kޤǤȥӥåjj+kޤǤαƶ
    // IntLiveΥӥåi+jʾƤӥåȤʤС
    // ƤӥåȤϡIntLive򱦤iեȤΤˤʤ
    // IntLiveΥӥåi+jʾƤӥåȤСκǾ̤ӥåi+j+KȤ
    // ƤӥåȤ
    //  ӥåjj+Kޤ1
    //  ӥå0Kޤ1
    //  IntLive򱦤iե
    // λĤιʻˤʤ
    // :
    //    hgfedcba
    //  x 01010010
    // -----------
    //     fedcba
    //    dcba
    //    ba
    // -----------
    //    ****cba0
    //     |||
    //     ||a,dαƶ
    //     |a,b,d,eαƶ
    //     a,b,c,d,e,fαƶ(3ܤ1αƶ2ܤ1αƶ˴ޤޤ)
    IntConst b=rightmostOne(c.sub(a).divu(a)); // cκǲ̤2ܤ1
    IntConst v=propagateRight(v0.divu(b));
    return valueOf(v.mul(b).bor(v).bor(v0));
  }
/** ʤκդ³IntLive֤. */
  public IntLive inheritDivu0() {
    // ƤӥåȤ̤Ϥ٤Ƥ
    return valueOf(rightmostOne(val).neg());
  }
/** ʤαդ³IntLive֤. */
  public IntLive inheritDivu1() { return valueOf(val.size()); }
/** ʤαդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritDivu0(IntConst c1) {
    if(c1.size()!=val.size()) throw new IllegalArgumentException(this+" "+c1);
    IntConst a=rightmostOne(c1);
    if(a.equals(c1)) return valueOf(val.mul(a)); // c12Τ٤ʤ饷եȤƱ c10ʤ
    IntConst b=IntConst.valueOf(c1.size(),0).bnot().divu(c1); // κ
    // ξ0ΥӥåȤƤʤ϶
    if(val.band(propagateRight(b)).signum()==0) return empty(val.size());
    // c1κǲ̤1ӥåiIntLiveƤǲ̤ӥåjȤ
    // ӥå0i+j-1ޤǤϻǤ뤬ӥåi+jʾӥåȤƤ
    // :
    //       Ͼ0
    //       ||a,bαƶ(cαƶϤʤ)
    //       |||
    //       |||   a,b,c,d,e,fαƶ
    //       |||   |a,b,c,d,e,f,gαƶ
    //       |||   ||
    //     __________ hϾ˱ƶʤ
    // 110 ) abcdefgh
    return valueOf(a.mul(rightmostOne(val)).neg());
  }
/** ʤκդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritDivu1(IntConst c0) {
    if(c0.size()!=val.size()) throw new IllegalArgumentException(this+" "+c0);
    return valueOf(val.size());
  }
/** Ĥκդ³IntLive֤. */
  public IntLive inheritDivs0() { return allOrEmpty(val,val.size()); }
/** Ĥαդ³IntLive֤. */
  public IntLive inheritDivs1() { return valueOf(val.size()); }
/** Ĥαդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritDivs0(IntConst c1) {
    if(c1.size()!=val.size()) throw new IllegalArgumentException(this+" "+c1);
    if(c1.signum()==0) return empty(val.size()); // c10ʤ
    if(val.signum()==0) return this; // IntLiveʤ餽Τޤ
    final IntConst zero=IntConst.valueOf(c1.size(),0);
    final IntConst one=IntConst.valueOf(c1.size(),1);
    final IntConst msb=one.lsh(c1.size()-1);
    final IntConst all=zero.bnot();
    if(c1.equals(one)) return this; // c11ʤ餽Τޤ
    if(c1.equals(all)) return inheritNeg(); // c1-1ʤNEGƱ
    IntConst c=c1.signum()>=0 ? c1 : c1.neg();
    IntConst a=rightmostOne(c);
    if(a.equals(c)) { // c12Τ٤ȿžΤȤ
      // c1(1<<i)ʤ顢
      // Υӥåi겼ΥӥåkϡΥӥåi+kʲӥåȤmsbαƶ
      // ΥӥåiʾϡӥåȤαƶ
      // : c1=001000ΤȤ
      // (10)  -8       -7       -33       -1         0     -128       127       -1
      //   11111000 11111001  11011111 11111111  00000000 10000000  01111111 11111111
      //       11111111 00000000  11111100 00000000  00000000 11110000  00001111 00000000
      IntConst v=propagateRight(val).mul(a).add(a).sub(one).bor(msb);
      // c1((-1)<<i)ʤ顢c1ΤȤȻƤ뤬ʲۤʤ
      // ΤsӥåȤȤȡΥӥås-iʾϡΥӥåi겼αƶʤ
      // ʤc1msbΤߤʤ顢01ˤʤ뤳ȤϤʤΤǡ̰
      // : c1=111000ΤȤ
      // (10)  -8       -7        33        1        -1      127      -127        1
      //   11111000 11111001  00100001 00000001  11111111 01111111  10000001 00000001
      //       00000001 00000000  11111100 00000000  00000000 11110001  00001111 00000000
      // (10)-128     -127
      //   10000000 10000001
      //       00010000 00001111
      if(c1.signum()<0 && val.band(all.divu(a)).signum()==0) {
        v=a.equals(msb) ? zero : v.band(a.neg());
      }
      return valueOf(v);
    }
    IntConst v=all;
    if(a.equals(one)) { // c1ΤȤ
      // c1ʤ顢㳰ơӥåȤƶ
      if(c1.signum()>0) {
        // c1ʤ顢ǲ̤1ӥåi2ܤ1ӥåj
        // κ(msbΤߤcʤ)KӥåȤȤ
        // Τ٤ƤΥӥåȤϡ㳰ơΥӥåjʾӥåȤαƶ
        // ӥåK겼ΥӥåkϤˡΥӥåkʾαƶ
        v=rightmostOne(c.sub(one)).neg();
        IntConst b=msb.divu(c); // κ
        if(val.band(propagateRight(b)).signum()!=0) v=v.bor(rightmostOne(val).neg());
      }
      // κcˤ;-c+1ΤȤlsbmsbαƶʤ
      if(val.equals(one) && c.add(msb.mods(c)).equals(one)) v=v.band(msb.bnot());
      return valueOf(v);
    }
    // c1ΤȤϡӥåȤƶ
    if(c1.signum()<0) { // c1ΤȤ
      IntConst b=msb.divu(c); // κ
      // cκǲ̤1ӥåiκ(msbΤߤcʤ)KӥåȤȤ
      // ΥӥåKʾϡΥӥåi겼αƶʤ
      if(val.band(propagateRight(b)).signum()==0) v=v.band(a.neg());
    }
    return valueOf(v);
  }
/** Ĥκդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritDivs1(IntConst c0) { return inheritDivu1(c0); }
/** ʤ;κդ³IntLive֤. */
  public IntLive inheritModu0() { return allOrEmpty(val,val.size()); }
/** ʤ;αդ³IntLive֤. */
  public IntLive inheritModu1() { return valueOf(val.size()); }
/** ʤ;αդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritModu0(IntConst c1) {
    if(c1.size()!=val.size()) throw new IllegalArgumentException(this+" "+c1);
    if(c1.signum()==0) return empty(val.size()); // c10ʤ
    IntConst a=rightmostOne(c1);
    // c12Τ٤ʤѤƱ
    if(a.equals(c1)) return valueOf(val.band(a.sub(IntConst.valueOf(a.size(),1))));
    // c1κǲ̤1ӥåiǾ̤1ӥåjȤ
    // ;Υӥåi겼ϡΤޤ
    // ;ΥӥåijޤǤϡΥӥåiʾӥåȤαƶ
    // ;Υӥåj̤Ͼ0
    // :
    //     __________ 
    // 110 ) abcdefgh
    //
    //           ----
    //           ***h
    //            **0
    //           ----
    //            **h
    //           |||
    //           ||a,b,c,d,e,f,gαƶ
    //           |a,b,c,d,e,f,gαƶ
    //           ̤0
    IntConst b=propagateRight(c1).band(a.neg());
    if(val.band(b).signum()==0) return valueOf(a.sub(IntConst.valueOf(a.size(),1)).band(val));
    return valueOf(a.neg().bor(val));
  }
/** ʤ;κդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritModu1(IntConst c0) { return inheritDivu1(c0); }
/** Ĥ;κդ³IntLive֤. */
  public IntLive inheritMods0() { return inheritModu0(); }
/** Ĥ;αդ³IntLive֤. */
  public IntLive inheritMods1() { return valueOf(val.size()); }
/** Ĥ;αդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritMods0(IntConst c1) {
    if(c1.size()!=val.size()) throw new IllegalArgumentException(this+" "+c1);
    if(c1.signum()==0) return empty(val.size()); // c10ʤ
    final IntConst one=IntConst.valueOf(c1.size(),1);
    final IntConst msb=one.lsh(c1.size()-1);
    if(c1.signum()<0) c1=c1.neg(); // Ĥ;c1˱ƶʤ
    if(c1.equals(one)) return empty(c1.size()); // c11ʤ;Ͼ0
    IntConst a=rightmostOne(c1);
    if(a.equals(c1)) { // c12Τ٤(1<<i)ΤȤ
      IntConst v=val.band(a.sub(one)); // ӥåi겼ϤΤޤ
      // ӥåiʾΤ٤ƤΥӥåȤϡӥåi겼ӥåȤmsbαƶ
      // : c1=00010000ΤȤ
      // (10) -16      -14         4     -124
      //   11110000 11110010  00000100 10000100
      // ;    00000000 11110010  00000100 11110100
      if(val.band(a.neg()).signum()!=0) v=v.bor(a.sub(one)).bor(msb);
      return valueOf(v);
    }
    // c1κǲ̤1ӥåiȤ
    // ;Υӥåi겼ϡΤޤ
    // ;Υӥåiʾϡ㳰ơΥӥåiʾӥåȤαƶ
    // : c1=00010100(10ʤ20)ΤȤ
    // (10) -20      -84
    //   11101100 10101100
    // ;    00000000 11111100
    IntConst v=val;
    if(val.band(a.neg()).signum()!=0) v=v.bor(a.neg());
    // c1(i=0)ʤ顢;ΥӥåiĤޤlsbmsbαƶʤ礬
    // ϡκξ;-c1+1ΤȤǤ
    // : c1=000011ΤȤ
    //   000000 000001 000010 000011 100000 100001 100010 100011
    // ;    000000 000001 000010 000000 111110 111111 000000 111110
    if(val.equals(one) && a.equals(one) && c1.add(msb.mods(c1)).equals(one)) v=v.band(msb.bnot());
    // ;Τ-c1ΩäƤӥåȤϡΥӥåi겼αƶ
    // μαƶϾ;0ѲȤ˸¤
    // : c1=00010100(10ʤ20)ΤȤ
    // (10) -20      -19       -16      -15
    //   11101100 11101101  11111000 11111001
    // ;    00000000 11101101  11111000 11111001
    if(val.band(c1.neg()).signum()!=0) v=v.bor(a.sub(one));
    return valueOf(v);
  }
/** Ĥ;κդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritMods1(IntConst c0) { return inheritDivu1(c0); }
/** Ѥξդ³IntLive֤. */
  public IntLive inheritBand() { return this; }
/** Ѥΰդꤵ줿ΤȤ¾դ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritBand(IntConst c) { return valueOf(val.band(c)); }
/** ¤ξդ³IntLive֤. */
  public IntLive inheritBor() { return this; }
/** ¤ΰդꤵ줿ΤȤ¾դ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritBor(IntConst c) { return valueOf(val.band(c.bnot())); }
/** ¾Ū¤ξդ³IntLive֤. */
  public IntLive inheritBxor() { return this; }
/** ¾Ū¤ΰդꤵ줿ΤȤ¾դ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritBxor(IntConst c) {
    if(c.size()!=val.size()) throw new IllegalArgumentException(this+" "+c);
    return this;
  }
/** եȤκդ³IntLive֤. */
  public IntLive inheritLsh0() { return inheritAdd(); }
/** եȤα(ꤵ줿ӥåȿ)³IntLive֤.
 * @exception IllegalArgumentException ӥåȿǤʤ */
  public IntLive inheritLsh1(int t) { return allOrEmpty(val,t); }
/** եȤαդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritLsh0(IntConst c1) { return valueOf(val.rshu(c1)); }
/** եȤκդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritLsh1(IntConst c0,int t) { return inheritShift1(SHIFT_LSH,c0,t); }
/** ʤեȤκդ³IntLive֤. */
  public IntLive inheritRshu0() {
    return valueOf(rightmostOne(val).neg());
  }
/** ʤեȤα(ꤵ줿ӥåȿ)³IntLive֤.
 * @exception IllegalArgumentException ӥåȿǤʤ */
  public IntLive inheritRshu1(int t) { return allOrEmpty(val,t); }
/** ʤեȤαդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritRshu0(IntConst c1) { return valueOf(val.lsh(c1)); }
/** ʤեȤκդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritRshu1(IntConst c0,int t) { return inheritShift1(SHIFT_RSHU,c0,t); }
/** ĤեȤκդ³IntLive֤. */
  public IntLive inheritRshs0() { return inheritRshu0(); }
/** ĤեȤα(ꤵ줿ӥåȿ)³IntLive֤.
 * @exception IllegalArgumentException ӥåȿǤʤ */
  public IntLive inheritRshs1(int t) { return allOrEmpty(val.band(msbOnly(t).bnot()),t); }
/** ĤեȤαդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritRshs0(IntConst c1) {
    IntConst v=val.lsh(c1);
    // msbαƶΤӥåȤƤʤ顢msbƤ
    if(!v.rshu(c1).equals(val)) v=v.bor(msbOnly(val.size()));
    return valueOf(v);
  }
/** ĤեȤκդꤵ줿ΤȤդ³IntLive֤.
 * @exception IllegalArgumentException IntLiveȻꤵ줿Υӥåȿۤʤ */
  public IntLive inheritRshs1(IntConst c0,int t) { return inheritShift1(SHIFT_RSHS,c0,t); }
// ꤵ줿եȤκդꤵ줿ΤȤդ³IntLive֤
  private IntLive inheritShift1(Shift op,IntConst c0,int t) {
    final int size=val.size(),size2=size<<1;
    if(c0.size()!=size) throw new IllegalArgumentException(this+" "+c0);
    int v=0,s=0;
    // դ2^(r-1)ӥåȤĶ2^rӥåȰʲʤ顢դ򲼤r+1=sӥåȤ֤Ѥ˵
    // r+1>tʤtӥåȤ֤Ǥ褤
    for(int m=1;s<t && m!=0 && m-0x80000000<size2-0x80000000;m<<=1,s++) {
      IntConst a=IntConst.valueOf(size,0);
      for(int n=0;n<size;n=((n|m)+1)&~m) a=a.bor(op.eval(c0,n).bxor(op.eval(c0,n+m)));
      if(a.band(val).signum()!=0) v|=m;
    }
    // ӥåsʾϡޤǵ᤿Ǿ̥ӥåȤƱ
    return valueOf(IntConst.valueOf(s,v).convsx(t));
  }
/** ȿžΥڥɤ³IntLive֤. */
  public IntLive inheritNeg() { return inheritAdd(); }
/** Υڥɤ³IntLive֤. */
  public IntLive inheritBnot() { return this; }
/** ==ξ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTsteq(int t) {
    return allOrEmpty(val.band(IntConst.valueOf(val.size(),1)),t);
  }
/** ==ΰդꤵ줿ΤȤ¾դ³IntLive֤. */
  public IntLive inheritTsteq(IntConst c) {
    return allOrEmpty(val.band(IntConst.valueOf(val.size(),1)),c.size());
  }
/** !=ξ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstne(int t) { return inheritTsteq(t); }
/** !=ΰդꤵ줿ΤȤ¾դ³IntLive֤. */
  public IntLive inheritTstne(IntConst c) { return inheritTsteq(c); }
/** &lt;(ʤ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstltu0(int t) { return inheritTsteq(t); }
/** &lt;(ʤ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstltu1(int t) { return inheritTsteq(t); }
/** &lt;(ʤ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstltu0(IntConst c1) {
    if(val.band(IntConst.valueOf(val.size(),1)).signum()==0) return empty(c1.size());
    // դκǲ̤1겼ϻǤ
    return valueOf(rightmostOne(c1).neg());
  }
/** &lt;(ʤ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstltu1(IntConst c0) {
    if(val.band(IntConst.valueOf(val.size(),1)).signum()==0) return empty(c0.size());
    // +1κǲ̤1겼ϻǤ
    // դӥå1ʤåץ饦ɤ뤬ʤ
    return valueOf(rightmostOne(c0.add(IntConst.valueOf(c0.size(),1))).neg());
  }
/** &gt;(ʤ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstgtu0(int t) { return inheritTsteq(t); }
/** &gt;(ʤ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstgtu1(int t) { return inheritTsteq(t); }
/** &gt;(ʤ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstgtu0(IntConst c1) { return inheritTstltu1(c1); }
/** &gt;(ʤ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstgtu1(IntConst c0) { return inheritTstltu0(c0); }
/** &lt;=(ʤ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstleu0(int t) { return inheritTsteq(t); }
/** &lt;=(ʤ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstleu1(int t) { return inheritTsteq(t); }
/** &lt;=(ʤ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstleu0(IntConst c1) { return inheritTstltu1(c1); }
/** &lt;=(ʤ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstleu1(IntConst c0) { return inheritTstltu0(c0); }
/** &gt;=(ʤ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstgeu0(int t) { return inheritTsteq(t); }
/** &gt;=(ʤ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstgeu1(int t) { return inheritTsteq(t); }
/** &gt;=(ʤ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstgeu0(IntConst c1) { return inheritTstltu0(c1); }
/** &gt;=(ʤ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstgeu1(IntConst c0) { return inheritTstltu1(c0); }
/** &lt;(Ĥ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstlts0(int t) { return inheritTsteq(t); }
/** &lt;(Ĥ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstlts1(int t) { return inheritTsteq(t); }
/** &lt;(Ĥ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstlts0(IntConst c1) {
    if(val.band(IntConst.valueOf(val.size(),1)).signum()==0) return empty(c1.size());
    // +msbκǲ̤1겼ϻǤ
    return valueOf(rightmostOne(c1.add(msbOnly(c1.size()))).neg());
  }
/** &lt;(Ĥ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstlts1(IntConst c0) {
    if(val.band(IntConst.valueOf(val.size(),1)).signum()==0) return empty(c0.size());
    // +msb+1κǲ̤1겼ϻǤ
    return valueOf(rightmostOne(c0.sub(msbOnly(c0.size()).bnot())).neg());
  }
/** &gt;(Ĥ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstgts0(int t) { return inheritTsteq(t); }
/** &gt;(Ĥ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstgts1(int t) { return inheritTsteq(t); }
/** &gt;(Ĥ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstgts0(IntConst c1) { return inheritTstlts1(c1); }
/** &gt;(Ĥ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstgts1(IntConst c0) { return inheritTstlts0(c0); }
/** &lt;=(Ĥ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstles0(int t) { return inheritTsteq(t); }
/** &lt;=(Ĥ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstles1(int t) { return inheritTsteq(t); }
/** &lt;=(Ĥ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstles0(IntConst c1) { return inheritTstlts1(c1); }
/** &lt;=(Ĥ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstles1(IntConst c0) { return inheritTstlts0(c0); }
/** &gt;=(Ĥ)α(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstges0(int t) { return inheritTsteq(t); }
/** &gt;=(Ĥ)κ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritTstges1(int t) { return inheritTsteq(t); }
/** &gt;=(Ĥ)αդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstges0(IntConst c1) { return inheritTstlts0(c1); }
/** &gt;=(Ĥ)κդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritTstges1(IntConst c0) { return inheritTstlts1(c0); }
/** ĥΥڥ(ꤵ줿ӥåȿ)³IntLive֤.
 * @exception IllegalArgumentException ꤵ줿ӥåȿΤۤ礭ޤǤʤ */
  public IntLive inheritConvzx(int t) { return valueOf(val.convit(t)); }
/** ĥΥڥ(ꤵ줿ӥåȿ)³IntLive֤.
 * @exception IllegalArgumentException ꤵ줿ӥåȿΤۤ礭ޤǤʤ */
  public IntLive inheritConvsx(int t) {
    IntConst v=val.convit(t);
    // ĥʬƤʤ顢msbƤ
    IntConst a=IntConst.valueOf(val.size(),1).lsh(t).neg();
    if(val.band(a).signum()!=0) v=v.bor(msbOnly(t));
    return valueOf(v);
  }
/** ̾Υڥ(ꤵ줿ӥåȿ)³IntLive֤.
 * @exception IllegalArgumentException ꤵ줿ӥåȿΤۤ */
  public IntLive inheritConvit(int t) { return valueOf(val.convzx(t)); }
/** IFTHENELSEκ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritIfthenelse0(int t) { return allOrEmpty(val,t); }
/** IFTHENELSEդ³IntLive֤. */
  public IntLive inheritIfthenelse1() { return this; }
/** IFTHENELSEαդ³IntLive֤. */
  public IntLive inheritIfthenelse2() { return this; }
/** IFTHENELSEդꤵ줿ΤȤ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritIfthenelse0_1(int t,IntConst c1) { return inheritIfthenelse0(t); }
/** IFTHENELSEαդꤵ줿ΤȤ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritIfthenelse0_2(int t,IntConst c2) { return inheritIfthenelse0(t); }
/** IFTHENELSEκդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritIfthenelse1_0(IntConst c0) { return c0.signum()!=0 ? this : empty(val.size()); }
/** IFTHENELSEαդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritIfthenelse1_2(IntConst c2) { return inheritIfthenelse1(); }
/** IFTHENELSEκդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritIfthenelse2_0(IntConst c0) { return c0.signum()==0 ? this : empty(val.size()); }
/** IFTHENELSEդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritIfthenelse2_1(IntConst c1) { return inheritIfthenelse2(); }
/** IFTHENELSEդȱդꤵ줿ΤȤ(ꤵ줿ӥåȿ)³IntLive֤. */
  public IntLive inheritIfthenelse0(int t,IntConst c1,IntConst c2) {
    return allOrEmpty(c1.bxor(c2).band(val),t);
  }
/** IFTHENELSEκդȱդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritIfthenelse1(IntConst c0,IntConst c2) { return inheritIfthenelse1_0(c0); }
/** IFTHENELSEκդդꤵ줿ΤȤդ³IntLive֤. */
  public IntLive inheritIfthenelse2(IntConst c0,IntConst c1) { return inheritIfthenelse2_0(c0); }
/** IntLiveƤӥåȤΩäƤ֤. */
  public IntConst intConstValue() { return val; }
/** IntLiveȻꤵ줿֥Ȥɤ֤. */
  public boolean equals(Object o) {
    return o==this || o instanceof IntLive && val.equals((((IntLive)o).val));
  }
/** IntLiveΥϥå女ɤ֤. */
  public int hashCode() { return val.hashCode(); }
/** IntLiveʸɽ֤. */
  public String toString() {
    StringBuffer sb=new StringBuffer("{");
    final IntConst one=IntConst.valueOf(val.size(),1);
    int j=-2;
    for(int i=0;i<val.size();i++) {
      int s=val.rshu(i).band(one).signum();
      if(j<0 && s>0) {
        if(j==-1) sb.append(',');
        sb.append(i);
        j=i; 
      }
      if(j>=0 && s==0) {
        if(i>j+1) sb.append("..").append(i-1);
        j=-1;
      }
    }
    if(j>=0 && j<val.size()-1) sb.append("..").append(val.size()-1);
    return sb.append("}:").append(val.size()).toString();
  }
// ǲ̤1
  private static IntConst rightmostOne(IntConst c) { return c.neg().band(c); }
// Ǿ̤1겼̤򤹤٤1
  private static IntConst propagateRight(IntConst c) {
    for(int i=1;i>=0 && i<c.size();i<<=1) c=c.bor(c.rshu(i));
    return c;
  }
// msb1
  private static IntConst msbOnly(int t) { return IntConst.valueOf(t,1).lsh(t-1); }
// 0ʤ餹٤ƤǤIntLive0ʳʤ餹٤ƤƤIntLive
  private static IntLive allOrEmpty(IntConst c,int t) {
    return c.signum()==0 ? empty(t) : valueOf(t);
  }

}
