package coins.backend.gen;

import coins.backend.Storage;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;

public class MachineParams_sh4 extends coins.backend.MachineParams {

  public void addRequired(SymTab symtbl) {
    symtbl.addSymbol("memcpy", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
  }

  public int nRegisters() { return 64; }
  public int nRegsets() { return 79; }

  public int typeAddress() { return 514; }
  public int typeBool() { return 514; }
  public String[] getSymName() {
    return new String[]{
      "%rll0",
      "%rll2",
      "%rll4",
      "%rll6",
      "%rll8",
      "%rll10",
      "%rll12",
      "%rll14",
      "%r0",
      "%r1",
      "%r2",
      "%r3",
      "%r4",
      "%r5",
      "%r6",
      "%r7",
      "%r8",
      "%r9",
      "%r10",
      "%r11",
      "%r12",
      "%r13",
      "%r14",
      "%r15",
      "%fr0",
      "%fr2",
      "%fr4",
      "%fr6",
      "%fr8",
      "%fr10",
      "%fr12",
      "%fr14",
      "%r0/I16/0",
      "%r1/I16/0",
      "%r2/I16/0",
      "%r3/I16/0",
      "%r4/I16/0",
      "%r5/I16/0",
      "%r6/I16/0",
      "%r7/I16/0",
      "%r0/I8/0",
      "%r1/I8/0",
      "%r2/I8/0",
      "%r3/I8/0",
      "%r4/I8/0",
      "%r5/I8/0",
      "%r6/I8/0",
      "%r7/I8/0",
      "%fr0/F32/0",
      "%fr2/F32/0",
      "%fr4/F32/0",
      "%fr6/F32/0",
      "%fr8/F32/0",
      "%fr10/F32/0",
      "%fr12/F32/0",
      "%fr14/F32/0",
      "%fr0/F32/1",
      "%fr2/F32/1",
      "%fr4/F32/1",
      "%fr6/F32/1",
      "%fr8/F32/1",
      "%fr10/F32/1",
      "%fr12/F32/1",
      "%fr14/F32/1",
    };
  };
  public int[] getSymType() {
    return new int[] {
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
    };
  };
  public int[] getSymRegNumber() {
    return new int[] {
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      0,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      54,
      55,
      46,
      47,
      48,
      49,
      50,
      51,
      52,
      53,
      22,
      23,
      24,
      25,
      26,
      27,
      28,
      29,
      30,
      31,
      32,
      33,
      34,
      35,
      36,
      37,
      38,
      39,
      40,
      41,
      42,
      43,
      44,
      45,
      56,
      57,
      58,
      59,
      60,
      61,
      62,
      63,
    };
  };

  public short[][] getOverlapReg() {
    return new short[][] { {},
  /* 1: */ {8,9,22,23,30,31,},
  /* 2: */ {10,11,24,25,32,33,},
  /* 3: */ {12,13,26,27,34,35,},
  /* 4: */ {14,15,28,29,36,37,},
  /* 5: */ {16,17,},
  /* 6: */ {18,19,},
  /* 7: */ {20,21,},
  /* 8: */ {1,22,30,},
  /* 9: */ {1,23,31,},
  /* 10: */ {2,24,32,},
  /* 11: */ {2,25,33,},
  /* 12: */ {3,26,34,},
  /* 13: */ {3,27,35,},
  /* 14: */ {4,28,36,},
  /* 15: */ {4,29,37,},
  /* 16: */ {5,},
  /* 17: */ {5,},
  /* 18: */ {6,},
  /* 19: */ {6,},
  /* 20: */ {7,},
  /* 21: */ {7,},
  /* 22: */ {1,8,30,},
  /* 23: */ {1,9,31,},
  /* 24: */ {2,10,32,},
  /* 25: */ {2,11,33,},
  /* 26: */ {3,12,34,},
  /* 27: */ {3,13,35,},
  /* 28: */ {4,14,36,},
  /* 29: */ {4,15,37,},
  /* 30: */ {1,8,22,},
  /* 31: */ {1,9,23,},
  /* 32: */ {2,10,24,},
  /* 33: */ {2,11,25,},
  /* 34: */ {3,12,26,},
  /* 35: */ {3,13,27,},
  /* 36: */ {4,14,28,},
  /* 37: */ {4,15,29,},
  /* 38: */ {46,},
  /* 39: */ {47,},
  /* 40: */ {48,},
  /* 41: */ {49,},
  /* 42: */ {50,},
  /* 43: */ {51,},
  /* 44: */ {52,},
  /* 45: */ {53,},
  /* 46: */ {38,56,},
  /* 47: */ {39,57,},
  /* 48: */ {40,58,},
  /* 49: */ {41,59,},
  /* 50: */ {42,60,},
  /* 51: */ {43,61,},
  /* 52: */ {44,62,},
  /* 53: */ {45,63,},
  /* 54: */ {},
  /* 55: */ {},
  /* 56: */ {46,},
  /* 57: */ {47,},
  /* 58: */ {48,},
  /* 59: */ {49,},
  /* 60: */ {50,},
  /* 61: */ {51,},
  /* 62: */ {52,},
  /* 63: */ {53,},
    };
  };

  public short[][] getSuperReg() {
    return new short[][] { {},
  /* 1: */ {},
  /* 2: */ {},
  /* 3: */ {},
  /* 4: */ {},
  /* 5: */ {},
  /* 6: */ {},
  /* 7: */ {},
  /* 8: */ {1,},
  /* 9: */ {1,},
  /* 10: */ {2,},
  /* 11: */ {2,},
  /* 12: */ {3,},
  /* 13: */ {3,},
  /* 14: */ {4,},
  /* 15: */ {4,},
  /* 16: */ {5,},
  /* 17: */ {5,},
  /* 18: */ {6,},
  /* 19: */ {6,},
  /* 20: */ {7,},
  /* 21: */ {7,},
  /* 22: */ {1,8,},
  /* 23: */ {1,9,},
  /* 24: */ {2,10,},
  /* 25: */ {2,11,},
  /* 26: */ {3,12,},
  /* 27: */ {3,13,},
  /* 28: */ {4,14,},
  /* 29: */ {4,15,},
  /* 30: */ {1,8,22,},
  /* 31: */ {1,9,23,},
  /* 32: */ {2,10,24,},
  /* 33: */ {2,11,25,},
  /* 34: */ {3,12,26,},
  /* 35: */ {3,13,27,},
  /* 36: */ {4,14,28,},
  /* 37: */ {4,15,29,},
  /* 38: */ {46,},
  /* 39: */ {47,},
  /* 40: */ {48,},
  /* 41: */ {49,},
  /* 42: */ {50,},
  /* 43: */ {51,},
  /* 44: */ {52,},
  /* 45: */ {53,},
  /* 46: */ {},
  /* 47: */ {},
  /* 48: */ {},
  /* 49: */ {},
  /* 50: */ {},
  /* 51: */ {},
  /* 52: */ {},
  /* 53: */ {},
  /* 54: */ {},
  /* 55: */ {},
  /* 56: */ {46,},
  /* 57: */ {47,},
  /* 58: */ {48,},
  /* 59: */ {49,},
  /* 60: */ {50,},
  /* 61: */ {51,},
  /* 62: */ {52,},
  /* 63: */ {53,},
    };
  };

  public short[][] getSubReg() {
    return new short[][] { {},
  /* 1: */ {8,9,22,23,30,31,},
  /* 2: */ {10,11,24,25,32,33,},
  /* 3: */ {12,13,26,27,34,35,},
  /* 4: */ {14,15,28,29,36,37,},
  /* 5: */ {16,17,},
  /* 6: */ {18,19,},
  /* 7: */ {20,21,},
  /* 8: */ {22,30,},
  /* 9: */ {23,31,},
  /* 10: */ {24,32,},
  /* 11: */ {25,33,},
  /* 12: */ {26,34,},
  /* 13: */ {27,35,},
  /* 14: */ {28,36,},
  /* 15: */ {29,37,},
  /* 16: */ {},
  /* 17: */ {},
  /* 18: */ {},
  /* 19: */ {},
  /* 20: */ {},
  /* 21: */ {},
  /* 22: */ {30,},
  /* 23: */ {31,},
  /* 24: */ {32,},
  /* 25: */ {33,},
  /* 26: */ {34,},
  /* 27: */ {35,},
  /* 28: */ {36,},
  /* 29: */ {37,},
  /* 30: */ {},
  /* 31: */ {},
  /* 32: */ {},
  /* 33: */ {},
  /* 34: */ {},
  /* 35: */ {},
  /* 36: */ {},
  /* 37: */ {},
  /* 38: */ {},
  /* 39: */ {},
  /* 40: */ {},
  /* 41: */ {},
  /* 42: */ {},
  /* 43: */ {},
  /* 44: */ {},
  /* 45: */ {},
  /* 46: */ {38,56,},
  /* 47: */ {39,57,},
  /* 48: */ {40,58,},
  /* 49: */ {41,59,},
  /* 50: */ {42,60,},
  /* 51: */ {43,61,},
  /* 52: */ {44,62,},
  /* 53: */ {45,63,},
  /* 54: */ {},
  /* 55: */ {},
  /* 56: */ {},
  /* 57: */ {},
  /* 58: */ {},
  /* 59: */ {},
  /* 60: */ {},
  /* 61: */ {},
  /* 62: */ {},
  /* 63: */ {},
    };
  };

  public String[] getRegsetName() {
    return new String[] {
      "*reg-I32-R01*",
      "*reg-I32-R45*",
      "*reg-I32-R67*",
      "*reg-I32-R0*",
      "*reg-I32-R1*",
      "*reg-I32-R2*",
      "*reg-I32-R3*",
      "*reg-I32-R4*",
      "*reg-I32-R5*",
      "*reg-I32-R6*",
      "*reg-I32-R7*",
      "*reg-I32-R8*",
      "*reg-I32-R9*",
      "*reg-I32-R10*",
      "*reg-I32-R11*",
      "*reg-I32-R12*",
      "*reg-I32-R13*",
      "*reg-I32-FR0*",
      "*reg-I32-FR2*",
      "*reg-I32-FR4*",
      "*reg-I32-FR6*",
      "*reg-I32-FR8*",
      "*reg-I32-FR10*",
      "*reg-I32-FR12*",
      "*reg-I32-FR14*",
      "*reg-I32-R14*",
      "*reg-I32-R15*",
      "*reg-I32-FR1*",
      "*reg-I32-FR3*",
      "*reg-I32-FR5*",
      "*reg-I32-FR7*",
      "*reg-I32-FR9*",
      "*reg-I32-FR11*",
      "*reg-I32-FR13*",
      "*reg-I32-FR15*",
      "*reg-I64*",
      "*reg-I32*",
      "*reg-I32-notR0*",
      "*reg-I32-notR2R3*",
      "*reg-I32-notR0R2R3*",
      "*reg-I16*",
      "*reg-I8*",
      "*reg-F32*",
      "*reg-F64*",
      "*reg-call-clobbers*",
    };
  };
  public int[] getRegsetNumber() {
    return new int[] {
      1,
      3,
      4,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      38,
      39,
      40,
      41,
      42,
      43,
      44,
      45,
      54,
      55,
      56,
      57,
      58,
      59,
      60,
      61,
      62,
      63,
      64,
      65,
      66,
      67,
      68,
      69,
      70,
      71,
      72,
      73,
    };
  };
  public short[][] getRegsetMap() {
    return new short[][] {
      {1,2,3,4,5,6,7,},
      {8,9,10,11,12,13,14,15,16,17,18,19,20,21,},
      {9,10,11,12,13,14,15,16,17,18,19,20,21,},
      {8,9,12,13,14,15,16,17,18,19,20,21,},
      {9,12,13,14,15,16,17,18,19,20,21,},
      {22,23,24,25,26,27,28,29,},
      {30,31,32,33,34,35,36,37,},
      {38,39,40,41,42,43,44,45,},
      {46,47,48,49,50,51,52,53,},
      {8,9,10,11,12,13,14,15,46,47,48,49,},
      {8,9,10,11,12,13,14,15,},
      {9,10,11,12,13,14,15,},
      {8,9,12,13,14,15,},
      {9,12,13,14,15,},
      {46,47,48,49,},
    };
  };

  public short[] getRegsetNAvail() {
    return new short[] {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 7, 14, 13, 12, 11, 8, 
      8, 8, 8, 12, 8, 7, 6, 5, 4,     };
  };

  public int[] getCompAndTbl() {
    return new int[] {
      -2017,1,2,3,4,5,6,7,
      -2088,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
      -2154,9,10,11,12,13,14,15,16,17,18,19,20,21,
      -2210,66,
      -2219,8,9,
      -2223,12,13,14,15,16,17,18,19,20,21,
      -2276,67,68,
      -2287,9,
      -2290,12,13,14,15,16,17,18,19,20,21,
      -2343,68,68,68,
      -2368,22,23,24,25,26,27,28,29,
      -2445,30,31,32,33,34,35,36,37,
      -2523,38,39,40,41,42,43,44,45,
      -2602,46,47,48,49,50,51,52,53,
      -2636,8,9,10,11,12,13,14,15,
      -2674,46,47,48,49,
      -2693,74,75,76,77,
      -2700,78,
      -2709,8,9,10,11,12,13,14,15,
      -2766,74,75,76,77,
      -2774,74,
      -2784,9,10,11,12,13,14,15,
      -2840,75,75,77,77,
      -2848,75,75,
      -2858,8,9,
      -2862,12,13,14,15,
      -2915,76,77,76,77,
      -2923,76,76,77,
      -2935,9,
      -2938,12,13,14,15,
      -2991,77,77,77,77,
      -2999,77,77,77,77,
      -3049,46,47,48,49,
      -3075,78,78,
    };
  };

  public int[] getCompWeightTbl() {
    return new int[] {
    80,65,
    87,129,
    101,129,
    109,129,
    143,449,
    152,321,
    160,65,
    168,129,
    182,129,
    190,129,
    222,193,
    227,129,
    231,193,
    240,65,
    249,129,
    263,129,
    271,129,
    301,449,
    310,321,
    320,65,
    330,129,
    344,129,
    352,129,
    380,449,
    389,321,
    400,65,
    411,129,
    459,321,
    480,65,
    492,129,
    538,321,
    560,65,
    573,129,
    617,321,
    633,65,
    640,65,
    654,65,
    662,65,
    696,129,
    699,65,
    701,129,
    705,129,
    708,65,
    712,65,
    720,65,
    734,65,
    742,65,
    775,449,
    784,321,
    792,65,
    800,65,
    814,65,
    822,65,
    854,193,
    859,129,
    863,193,
    871,65,
    880,65,
    894,65,
    902,65,
    933,193,
    938,129,
    942,193,
    951,65,
    960,65,
    974,65,
    982,65,
    1012,449,
    1021,321,
    1030,65,
    1040,65,
    1054,65,
    1062,65,
    1091,449,
    1100,321,
    1110,65,
    1120,65,
    1134,65,
    1142,65,
    1170,449,
    1179,321,
    1189,65,
    1200,65,
    1214,65,
    1222,65,
    1249,449,
    1258,321,
    1269,65,
    1280,65,
    1328,321,
    1348,65,
    1360,65,
    1407,321,
    1428,65,
    1440,65,
    1486,321,
    1507,65,
    1520,65,
    1565,321,
    1587,65,
    1600,65,
    1644,321,
    1666,65,
    1680,65,
    1723,321,
    1739,65,
    1746,65,
    1760,65,
    1768,65,
    1802,129,
    1805,65,
    1807,129,
    1811,129,
    1814,65,
    1818,65,
    1826,65,
    1840,65,
    1848,65,
    1881,449,
    1890,321,
    1898,65,
    1906,65,
    1920,65,
    1928,65,
    1960,193,
    1965,129,
    1969,193,
    1977,65,
    1986,65,
    2000,65,
    2008,65,
    2039,193,
    2044,129,
    2048,193,
    2057,65,
    2066,65,
    2080,65,
    2088,65,
    2118,449,
    2127,321,
    2136,65,
    2146,65,
    2160,65,
    2168,65,
    2197,449,
    2206,321,
    2216,65,
    2226,65,
    2240,65,
    2248,65,
    2276,449,
    2285,321,
    2295,65,
    2306,65,
    2320,65,
    2328,65,
    2355,449,
    2364,321,
    2371,65,
    2378,65,
    2392,65,
    2400,65,
    2434,129,
    2437,65,
    2439,129,
    2443,129,
    2446,65,
    2450,65,
    2458,65,
    2472,65,
    2480,65,
    2513,449,
    2522,321,
    2530,65,
    2538,65,
    2552,65,
    2560,65,
    2592,193,
    2597,129,
    2601,193,
    2609,65,
    2618,65,
    2632,65,
    2640,65,
    2671,193,
    2676,129,
    2680,193,
    2689,65,
    2698,65,
    2712,65,
    2720,65,
    2750,449,
    2759,321,
    2768,65,
    2778,65,
    2792,65,
    2800,65,
    2829,449,
    2838,321,
    2848,65,
    2858,65,
    2872,65,
    2880,65,
    2908,449,
    2917,321,
    2927,65,
    2938,65,
    2952,65,
    2960,65,
    2987,449,
    2996,321,
    3040,65,
    3048,65,
    3073,193,
    3080,65,
    3120,65,
    3128,65,
    3152,193,
    3159,65,
    3200,65,
    3208,65,
    3231,193,
    3238,65,
    3280,65,
    3288,65,
    3310,193,
    3317,65,
    3360,65,
    3368,65,
    3389,129,
    3440,65,
    3448,65,
    3468,129,
    3520,65,
    3528,65,
    3547,129,
    3600,65,
    3608,65,
    3626,129,
    3672,65,
    3680,65,
    3690,65,
    3705,193,
    3712,65,
    3752,65,
    3760,65,
    3770,65,
    3784,193,
    3791,65,
    3832,65,
    3840,65,
    3850,65,
    3863,193,
    3870,65,
    3912,65,
    3920,65,
    3930,65,
    3942,193,
    3949,65,
    3992,65,
    4000,65,
    4010,65,
    4021,129,
    4072,65,
    4080,65,
    4090,65,
    4100,129,
    4152,65,
    4160,65,
    4170,65,
    4179,129,
    4232,65,
    4240,65,
    4250,65,
    4258,129,
    4320,65,
    4400,65,
    4470,65,
    4480,65,
    4496,129,
    4502,65,
    4550,65,
    4560,65,
    4575,129,
    4581,65,
    4630,65,
    4640,65,
    4654,129,
    4660,65,
    4710,65,
    4720,65,
    4733,129,
    4739,65,
    4790,65,
    4800,65,
    4812,65,
    4870,65,
    4880,65,
    4891,65,
    4950,65,
    4960,65,
    4970,65,
    5030,65,
    5040,65,
    5049,65,
    5057,2369,
    5120,449,
    5129,321,
    5136,450,
    5143,1921,
    5199,66,
    5200,385,
    5208,321,
    5215,65,
    5216,386,
    5223,833,
    5237,449,
    5245,449,
    5278,66,
    5279,385,
    5287,321,
    5294,66,
    5296,322,
    5301,129,
    5305,769,
    5319,385,
    5327,257,
    5357,66,
    5358,385,
    5366,321,
    5373,65,
    5375,322,
    5381,65,
    5384,641,
    5395,65,
    5398,257,
    5403,65,
    5406,257,
    5436,66,
    5437,385,
    5445,321,
    5452,258,
    5459,513,
    5473,1025,
    5515,66,
    5516,385,
    5524,321,
    5531,258,
    5538,513,
    5552,1025,
    5594,66,
    5595,385,
    5603,321,
    5647,1025,
    5680,193,
    5687,65,
    5726,1025,
    5744,513,
    5759,193,
    5766,65,
    5768,258,
    5775,513,
    5789,1281,
    5813,257,
    5823,257,
    5831,66,
    5832,897,
    5847,258,
    5854,513,
    5868,1025,
    5910,66,
    5911,385,
    5919,321,
    5926,65,
    5927,194,
    5934,449,
    5948,449,
    5956,449,
    5989,66,
    5990,385,
    5998,321,
    6005,66,
    6007,130,
    6012,129,
    6016,257,
    6026,129,
    6030,385,
    6038,257,
    6068,66,
    6069,385,
    6077,321,
    6084,65,
    6086,130,
    6092,65,
    6095,257,
    6106,65,
    6109,257,
    6114,65,
    6117,257,
    6147,66,
    6148,385,
    6156,321,
    6200,257,
    6208,257,
    6218,257,
    6233,193,
    6240,65,
    };
  };

  public int[] getRegsetTypeTbl() {
    return new int[] {
    -1,
    514,
    1026,
    514,
    514,
    1026,
    1026,
    1026,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    514,
    514,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    1026,
    514,
    514,
    514,
    514,
    258,
    130,
    516,
    1028,
    514,
    514,
    514,
    514,
    514,
    514,
    };
  }
}
