package coins.backend.gen;

import coins.backend.Storage;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;

public class MachineParams_sparc extends coins.backend.MachineParams {

  public void addRequired(SymTab symtbl) {
    symtbl.addSymbol("memcpy", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol("__dtoll", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol("__ftoll", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol(".stackRequired", Storage.STATIC, 0, 4, "abs", "XREF", ImList.Empty);
  }

  public int nRegisters() { return 139; }
  public int nRegsets() { return 147; }

  public int typeAddress() { return 514; }
  public int typeBool() { return 514; }
  public String[] getSymName() {
    return new String[]{
      "%l01",
      "%l23",
      "%l45",
      "%l67",
      "%i01",
      "%i23",
      "%i45",
      "%o01",
      "%o23",
      "%o45",
      "%g0",
      "%g1",
      "%g2",
      "%g3",
      "%g4",
      "%g5",
      "%g6",
      "%g7",
      "%l0",
      "%l1",
      "%l2",
      "%l3",
      "%l4",
      "%l5",
      "%l6",
      "%l7",
      "%o0",
      "%o1",
      "%o2",
      "%o3",
      "%o4",
      "%o5",
      "%i0",
      "%i1",
      "%i2",
      "%i3",
      "%i4",
      "%i5",
      "%f0",
      "%f2",
      "%f4",
      "%f6",
      "%f8",
      "%f10",
      "%f12",
      "%f14",
      "%f16",
      "%f18",
      "%f20",
      "%f22",
      "%f24",
      "%f26",
      "%f28",
      "%f30",
      "%sp",
      "%fp",
      "%i0/I16/0",
      "%i1/I16/0",
      "%i2/I16/0",
      "%i3/I16/0",
      "%i4/I16/0",
      "%i5/I16/0",
      "%o0/I16/0",
      "%o1/I16/0",
      "%o2/I16/0",
      "%o3/I16/0",
      "%o4/I16/0",
      "%o5/I16/0",
      "%l0/I16/0",
      "%l1/I16/0",
      "%l2/I16/0",
      "%l3/I16/0",
      "%l4/I16/0",
      "%l5/I16/0",
      "%l6/I16/0",
      "%l7/I16/0",
      "%g2/I16/0",
      "%g3/I16/0",
      "%g4/I16/0",
      "%g5/I16/0",
      "%g6/I16/0",
      "%g7/I16/0",
      "%i0/I8/0",
      "%i1/I8/0",
      "%i2/I8/0",
      "%i3/I8/0",
      "%i4/I8/0",
      "%i5/I8/0",
      "%o0/I8/0",
      "%o1/I8/0",
      "%o2/I8/0",
      "%o3/I8/0",
      "%o4/I8/0",
      "%o5/I8/0",
      "%l0/I8/0",
      "%l1/I8/0",
      "%l2/I8/0",
      "%l3/I8/0",
      "%l4/I8/0",
      "%l5/I8/0",
      "%l6/I8/0",
      "%l7/I8/0",
      "%g2/I8/0",
      "%g3/I8/0",
      "%g4/I8/0",
      "%g5/I8/0",
      "%g6/I8/0",
      "%g7/I8/0",
      "%f0/F32/0",
      "%f0/F32/1",
      "%f2/F32/0",
      "%f2/F32/1",
      "%f4/F32/0",
      "%f4/F32/1",
      "%f6/F32/0",
      "%f6/F32/1",
      "%f8/F32/0",
      "%f8/F32/1",
      "%f10/F32/0",
      "%f10/F32/1",
      "%f12/F32/0",
      "%f12/F32/1",
      "%f14/F32/0",
      "%f14/F32/1",
      "%f16/F32/0",
      "%f16/F32/1",
      "%f18/F32/0",
      "%f18/F32/1",
      "%f20/F32/0",
      "%f20/F32/1",
      "%f22/F32/0",
      "%f22/F32/1",
      "%f24/F32/0",
      "%f24/F32/1",
      "%f26/F32/0",
      "%f26/F32/1",
      "%f28/F32/0",
      "%f28/F32/1",
      "%f30/F32/0",
      "%f30/F32/1",
    };
  };
  public int[] getSymType() {
    return new int[] {
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      514,
      514,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
    };
  };
  public int[] getSymRegNumber() {
    return new int[] {
      7,
      8,
      9,
      10,
      1,
      2,
      3,
      4,
      5,
      6,
      137,
      138,
      31,
      32,
      33,
      34,
      35,
      36,
      23,
      24,
      25,
      26,
      27,
      28,
      29,
      30,
      17,
      18,
      19,
      20,
      21,
      22,
      11,
      12,
      13,
      14,
      15,
      16,
      89,
      90,
      91,
      92,
      93,
      94,
      95,
      96,
      97,
      98,
      99,
      100,
      101,
      102,
      103,
      104,
      0,
      0,
      37,
      38,
      39,
      40,
      41,
      42,
      43,
      44,
      45,
      46,
      47,
      48,
      49,
      50,
      51,
      52,
      53,
      54,
      55,
      56,
      57,
      58,
      59,
      60,
      61,
      62,
      63,
      64,
      65,
      66,
      67,
      68,
      69,
      70,
      71,
      72,
      73,
      74,
      75,
      76,
      77,
      78,
      79,
      80,
      81,
      82,
      83,
      84,
      85,
      86,
      87,
      88,
      105,
      106,
      107,
      108,
      109,
      110,
      111,
      112,
      113,
      114,
      115,
      116,
      117,
      118,
      119,
      120,
      121,
      122,
      123,
      124,
      125,
      126,
      127,
      128,
      129,
      130,
      131,
      132,
      133,
      134,
      135,
      136,
    };
  };

  public short[][] getOverlapReg() {
    return new short[][] { {},
  /* 1: */ {11,12,37,38,63,64,},
  /* 2: */ {13,14,39,40,65,66,},
  /* 3: */ {15,16,41,42,67,68,},
  /* 4: */ {17,18,43,44,69,70,},
  /* 5: */ {19,20,45,46,71,72,},
  /* 6: */ {21,22,47,48,73,74,},
  /* 7: */ {23,24,49,50,75,76,},
  /* 8: */ {25,26,51,52,77,78,},
  /* 9: */ {27,28,53,54,79,80,},
  /* 10: */ {29,30,55,56,81,82,},
  /* 11: */ {1,37,63,},
  /* 12: */ {1,38,64,},
  /* 13: */ {2,39,65,},
  /* 14: */ {2,40,66,},
  /* 15: */ {3,41,67,},
  /* 16: */ {3,42,68,},
  /* 17: */ {4,43,69,},
  /* 18: */ {4,44,70,},
  /* 19: */ {5,45,71,},
  /* 20: */ {5,46,72,},
  /* 21: */ {6,47,73,},
  /* 22: */ {6,48,74,},
  /* 23: */ {7,49,75,},
  /* 24: */ {7,50,76,},
  /* 25: */ {8,51,77,},
  /* 26: */ {8,52,78,},
  /* 27: */ {9,53,79,},
  /* 28: */ {9,54,80,},
  /* 29: */ {10,55,81,},
  /* 30: */ {10,56,82,},
  /* 31: */ {57,83,},
  /* 32: */ {58,84,},
  /* 33: */ {59,85,},
  /* 34: */ {60,86,},
  /* 35: */ {61,87,},
  /* 36: */ {62,88,},
  /* 37: */ {1,11,63,},
  /* 38: */ {1,12,64,},
  /* 39: */ {2,13,65,},
  /* 40: */ {2,14,66,},
  /* 41: */ {3,15,67,},
  /* 42: */ {3,16,68,},
  /* 43: */ {4,17,69,},
  /* 44: */ {4,18,70,},
  /* 45: */ {5,19,71,},
  /* 46: */ {5,20,72,},
  /* 47: */ {6,21,73,},
  /* 48: */ {6,22,74,},
  /* 49: */ {7,23,75,},
  /* 50: */ {7,24,76,},
  /* 51: */ {8,25,77,},
  /* 52: */ {8,26,78,},
  /* 53: */ {9,27,79,},
  /* 54: */ {9,28,80,},
  /* 55: */ {10,29,81,},
  /* 56: */ {10,30,82,},
  /* 57: */ {31,83,},
  /* 58: */ {32,84,},
  /* 59: */ {33,85,},
  /* 60: */ {34,86,},
  /* 61: */ {35,87,},
  /* 62: */ {36,88,},
  /* 63: */ {1,11,37,},
  /* 64: */ {1,12,38,},
  /* 65: */ {2,13,39,},
  /* 66: */ {2,14,40,},
  /* 67: */ {3,15,41,},
  /* 68: */ {3,16,42,},
  /* 69: */ {4,17,43,},
  /* 70: */ {4,18,44,},
  /* 71: */ {5,19,45,},
  /* 72: */ {5,20,46,},
  /* 73: */ {6,21,47,},
  /* 74: */ {6,22,48,},
  /* 75: */ {7,23,49,},
  /* 76: */ {7,24,50,},
  /* 77: */ {8,25,51,},
  /* 78: */ {8,26,52,},
  /* 79: */ {9,27,53,},
  /* 80: */ {9,28,54,},
  /* 81: */ {10,29,55,},
  /* 82: */ {10,30,56,},
  /* 83: */ {31,57,},
  /* 84: */ {32,58,},
  /* 85: */ {33,59,},
  /* 86: */ {34,60,},
  /* 87: */ {35,61,},
  /* 88: */ {36,62,},
  /* 89: */ {105,106,},
  /* 90: */ {107,108,},
  /* 91: */ {109,110,},
  /* 92: */ {111,112,},
  /* 93: */ {113,114,},
  /* 94: */ {115,116,},
  /* 95: */ {117,118,},
  /* 96: */ {119,120,},
  /* 97: */ {121,122,},
  /* 98: */ {123,124,},
  /* 99: */ {125,126,},
  /* 100: */ {127,128,},
  /* 101: */ {129,130,},
  /* 102: */ {131,132,},
  /* 103: */ {133,134,},
  /* 104: */ {135,136,},
  /* 105: */ {89,},
  /* 106: */ {89,},
  /* 107: */ {90,},
  /* 108: */ {90,},
  /* 109: */ {91,},
  /* 110: */ {91,},
  /* 111: */ {92,},
  /* 112: */ {92,},
  /* 113: */ {93,},
  /* 114: */ {93,},
  /* 115: */ {94,},
  /* 116: */ {94,},
  /* 117: */ {95,},
  /* 118: */ {95,},
  /* 119: */ {96,},
  /* 120: */ {96,},
  /* 121: */ {97,},
  /* 122: */ {97,},
  /* 123: */ {98,},
  /* 124: */ {98,},
  /* 125: */ {99,},
  /* 126: */ {99,},
  /* 127: */ {100,},
  /* 128: */ {100,},
  /* 129: */ {101,},
  /* 130: */ {101,},
  /* 131: */ {102,},
  /* 132: */ {102,},
  /* 133: */ {103,},
  /* 134: */ {103,},
  /* 135: */ {104,},
  /* 136: */ {104,},
  /* 137: */ {},
  /* 138: */ {},
    };
  };

  public short[][] getSuperReg() {
    return new short[][] { {},
  /* 1: */ {},
  /* 2: */ {},
  /* 3: */ {},
  /* 4: */ {},
  /* 5: */ {},
  /* 6: */ {},
  /* 7: */ {},
  /* 8: */ {},
  /* 9: */ {},
  /* 10: */ {},
  /* 11: */ {1,},
  /* 12: */ {1,},
  /* 13: */ {2,},
  /* 14: */ {2,},
  /* 15: */ {3,},
  /* 16: */ {3,},
  /* 17: */ {4,},
  /* 18: */ {4,},
  /* 19: */ {5,},
  /* 20: */ {5,},
  /* 21: */ {6,},
  /* 22: */ {6,},
  /* 23: */ {7,},
  /* 24: */ {7,},
  /* 25: */ {8,},
  /* 26: */ {8,},
  /* 27: */ {9,},
  /* 28: */ {9,},
  /* 29: */ {10,},
  /* 30: */ {10,},
  /* 31: */ {},
  /* 32: */ {},
  /* 33: */ {},
  /* 34: */ {},
  /* 35: */ {},
  /* 36: */ {},
  /* 37: */ {1,11,},
  /* 38: */ {1,12,},
  /* 39: */ {2,13,},
  /* 40: */ {2,14,},
  /* 41: */ {3,15,},
  /* 42: */ {3,16,},
  /* 43: */ {4,17,},
  /* 44: */ {4,18,},
  /* 45: */ {5,19,},
  /* 46: */ {5,20,},
  /* 47: */ {6,21,},
  /* 48: */ {6,22,},
  /* 49: */ {7,23,},
  /* 50: */ {7,24,},
  /* 51: */ {8,25,},
  /* 52: */ {8,26,},
  /* 53: */ {9,27,},
  /* 54: */ {9,28,},
  /* 55: */ {10,29,},
  /* 56: */ {10,30,},
  /* 57: */ {31,},
  /* 58: */ {32,},
  /* 59: */ {33,},
  /* 60: */ {34,},
  /* 61: */ {35,},
  /* 62: */ {36,},
  /* 63: */ {1,11,37,},
  /* 64: */ {1,12,38,},
  /* 65: */ {2,13,39,},
  /* 66: */ {2,14,40,},
  /* 67: */ {3,15,41,},
  /* 68: */ {3,16,42,},
  /* 69: */ {4,17,43,},
  /* 70: */ {4,18,44,},
  /* 71: */ {5,19,45,},
  /* 72: */ {5,20,46,},
  /* 73: */ {6,21,47,},
  /* 74: */ {6,22,48,},
  /* 75: */ {7,23,49,},
  /* 76: */ {7,24,50,},
  /* 77: */ {8,25,51,},
  /* 78: */ {8,26,52,},
  /* 79: */ {9,27,53,},
  /* 80: */ {9,28,54,},
  /* 81: */ {10,29,55,},
  /* 82: */ {10,30,56,},
  /* 83: */ {31,57,},
  /* 84: */ {32,58,},
  /* 85: */ {33,59,},
  /* 86: */ {34,60,},
  /* 87: */ {35,61,},
  /* 88: */ {36,62,},
  /* 89: */ {},
  /* 90: */ {},
  /* 91: */ {},
  /* 92: */ {},
  /* 93: */ {},
  /* 94: */ {},
  /* 95: */ {},
  /* 96: */ {},
  /* 97: */ {},
  /* 98: */ {},
  /* 99: */ {},
  /* 100: */ {},
  /* 101: */ {},
  /* 102: */ {},
  /* 103: */ {},
  /* 104: */ {},
  /* 105: */ {89,},
  /* 106: */ {89,},
  /* 107: */ {90,},
  /* 108: */ {90,},
  /* 109: */ {91,},
  /* 110: */ {91,},
  /* 111: */ {92,},
  /* 112: */ {92,},
  /* 113: */ {93,},
  /* 114: */ {93,},
  /* 115: */ {94,},
  /* 116: */ {94,},
  /* 117: */ {95,},
  /* 118: */ {95,},
  /* 119: */ {96,},
  /* 120: */ {96,},
  /* 121: */ {97,},
  /* 122: */ {97,},
  /* 123: */ {98,},
  /* 124: */ {98,},
  /* 125: */ {99,},
  /* 126: */ {99,},
  /* 127: */ {100,},
  /* 128: */ {100,},
  /* 129: */ {101,},
  /* 130: */ {101,},
  /* 131: */ {102,},
  /* 132: */ {102,},
  /* 133: */ {103,},
  /* 134: */ {103,},
  /* 135: */ {104,},
  /* 136: */ {104,},
  /* 137: */ {},
  /* 138: */ {},
    };
  };

  public short[][] getSubReg() {
    return new short[][] { {},
  /* 1: */ {11,12,37,38,63,64,},
  /* 2: */ {13,14,39,40,65,66,},
  /* 3: */ {15,16,41,42,67,68,},
  /* 4: */ {17,18,43,44,69,70,},
  /* 5: */ {19,20,45,46,71,72,},
  /* 6: */ {21,22,47,48,73,74,},
  /* 7: */ {23,24,49,50,75,76,},
  /* 8: */ {25,26,51,52,77,78,},
  /* 9: */ {27,28,53,54,79,80,},
  /* 10: */ {29,30,55,56,81,82,},
  /* 11: */ {37,63,},
  /* 12: */ {38,64,},
  /* 13: */ {39,65,},
  /* 14: */ {40,66,},
  /* 15: */ {41,67,},
  /* 16: */ {42,68,},
  /* 17: */ {43,69,},
  /* 18: */ {44,70,},
  /* 19: */ {45,71,},
  /* 20: */ {46,72,},
  /* 21: */ {47,73,},
  /* 22: */ {48,74,},
  /* 23: */ {49,75,},
  /* 24: */ {50,76,},
  /* 25: */ {51,77,},
  /* 26: */ {52,78,},
  /* 27: */ {53,79,},
  /* 28: */ {54,80,},
  /* 29: */ {55,81,},
  /* 30: */ {56,82,},
  /* 31: */ {57,83,},
  /* 32: */ {58,84,},
  /* 33: */ {59,85,},
  /* 34: */ {60,86,},
  /* 35: */ {61,87,},
  /* 36: */ {62,88,},
  /* 37: */ {63,},
  /* 38: */ {64,},
  /* 39: */ {65,},
  /* 40: */ {66,},
  /* 41: */ {67,},
  /* 42: */ {68,},
  /* 43: */ {69,},
  /* 44: */ {70,},
  /* 45: */ {71,},
  /* 46: */ {72,},
  /* 47: */ {73,},
  /* 48: */ {74,},
  /* 49: */ {75,},
  /* 50: */ {76,},
  /* 51: */ {77,},
  /* 52: */ {78,},
  /* 53: */ {79,},
  /* 54: */ {80,},
  /* 55: */ {81,},
  /* 56: */ {82,},
  /* 57: */ {83,},
  /* 58: */ {84,},
  /* 59: */ {85,},
  /* 60: */ {86,},
  /* 61: */ {87,},
  /* 62: */ {88,},
  /* 63: */ {},
  /* 64: */ {},
  /* 65: */ {},
  /* 66: */ {},
  /* 67: */ {},
  /* 68: */ {},
  /* 69: */ {},
  /* 70: */ {},
  /* 71: */ {},
  /* 72: */ {},
  /* 73: */ {},
  /* 74: */ {},
  /* 75: */ {},
  /* 76: */ {},
  /* 77: */ {},
  /* 78: */ {},
  /* 79: */ {},
  /* 80: */ {},
  /* 81: */ {},
  /* 82: */ {},
  /* 83: */ {},
  /* 84: */ {},
  /* 85: */ {},
  /* 86: */ {},
  /* 87: */ {},
  /* 88: */ {},
  /* 89: */ {105,106,},
  /* 90: */ {107,108,},
  /* 91: */ {109,110,},
  /* 92: */ {111,112,},
  /* 93: */ {113,114,},
  /* 94: */ {115,116,},
  /* 95: */ {117,118,},
  /* 96: */ {119,120,},
  /* 97: */ {121,122,},
  /* 98: */ {123,124,},
  /* 99: */ {125,126,},
  /* 100: */ {127,128,},
  /* 101: */ {129,130,},
  /* 102: */ {131,132,},
  /* 103: */ {133,134,},
  /* 104: */ {135,136,},
  /* 105: */ {},
  /* 106: */ {},
  /* 107: */ {},
  /* 108: */ {},
  /* 109: */ {},
  /* 110: */ {},
  /* 111: */ {},
  /* 112: */ {},
  /* 113: */ {},
  /* 114: */ {},
  /* 115: */ {},
  /* 116: */ {},
  /* 117: */ {},
  /* 118: */ {},
  /* 119: */ {},
  /* 120: */ {},
  /* 121: */ {},
  /* 122: */ {},
  /* 123: */ {},
  /* 124: */ {},
  /* 125: */ {},
  /* 126: */ {},
  /* 127: */ {},
  /* 128: */ {},
  /* 129: */ {},
  /* 130: */ {},
  /* 131: */ {},
  /* 132: */ {},
  /* 133: */ {},
  /* 134: */ {},
  /* 135: */ {},
  /* 136: */ {},
  /* 137: */ {},
  /* 138: */ {},
    };
  };

  public String[] getRegsetName() {
    return new String[] {
      "*reg-o01-I64*",
      "*reg-o23-I64*",
      "*reg-o0-I32*",
      "*reg-o1-I32*",
      "*reg-o2-I32*",
      "*reg-f01-F64*",
      "*reg-f0-F32*",
      "*reg-I64*",
      "*reg-I32*",
      "*reg-I16*",
      "*reg-I8*",
      "*reg-F64*",
      "*reg-F32*",
      "*reg-call-clobbers*",
    };
  };
  public int[] getRegsetNumber() {
    return new int[] {
      4,
      5,
      17,
      18,
      19,
      89,
      105,
      139,
      140,
      141,
      142,
      143,
      144,
      145,
    };
  };
  public short[][] getRegsetMap() {
    return new short[][] {
      {1,2,3,4,5,6,7,8,9,10,},
      {11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,},
      {37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,},
      {63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,},
      {89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,},
      {105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,},
      {17,18,19,20,21,22,31,32,33,34,35,36,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,137,138,},
      {17,18,19,20,21,22,31,32,33,34,35,36,},
    };
  };

  public short[] getRegsetNAvail() {
    return new short[] {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 10, 
      26, 26, 26, 16, 32, 30, 12,     };
  };

  public int[] getCompAndTbl() {
    return new int[] {
      -9592,1,2,3,4,5,6,7,8,9,10,
      -9741,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,
      -9907,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
      -10074,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,
      -10242,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,
      -10401,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,
      -10457,17,18,19,20,21,22,
      -10471,31,32,33,34,35,36,
      -10529,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,
      -10577,137,138,
      -10580,146,
      -10583,143,
      -10602,17,18,19,20,21,22,
      -10616,31,32,33,34,35,36,
      -10725,146,
      -10730,146,    };
  };

  public int[] getCompWeightTbl() {
    return new int[] {
    148,65,
    158,129,
    184,129,
    210,129,
    286,257,
    296,65,
    307,129,
    333,129,
    359,129,
    433,257,
    444,65,
    456,129,
    482,129,
    508,129,
    580,257,
    592,65,
    605,129,
    631,129,
    657,129,
    727,257,
    733,129,
    740,65,
    754,129,
    780,129,
    806,129,
    874,257,
    880,129,
    888,65,
    903,129,
    929,129,
    955,129,
    1021,257,
    1027,129,
    1036,65,
    1052,129,
    1078,129,
    1104,129,
    1168,257,
    1184,65,
    1201,129,
    1227,129,
    1253,129,
    1315,257,
    1332,65,
    1350,129,
    1376,129,
    1402,129,
    1462,257,
    1480,65,
    1499,129,
    1525,129,
    1551,129,
    1609,257,
    1618,65,
    1628,65,
    1654,65,
    1680,65,
    1756,257,
    1765,65,
    1776,65,
    1802,65,
    1828,65,
    1903,257,
    1913,65,
    1924,65,
    1950,65,
    1976,65,
    2050,257,
    2060,65,
    2072,65,
    2098,65,
    2124,65,
    2197,257,
    2208,65,
    2220,65,
    2246,65,
    2272,65,
    2344,257,
    2355,65,
    2368,65,
    2394,65,
    2420,65,
    2491,257,
    2503,65,
    2516,65,
    2542,65,
    2568,65,
    2638,257,
    2644,129,
    2650,65,
    2664,65,
    2690,65,
    2716,65,
    2785,257,
    2791,129,
    2798,65,
    2812,65,
    2838,65,
    2864,65,
    2932,257,
    2938,129,
    2945,65,
    2960,65,
    2986,65,
    3012,65,
    3079,257,
    3085,129,
    3093,65,
    3108,65,
    3134,65,
    3160,65,
    3226,257,
    3232,129,
    3240,65,
    3256,65,
    3282,65,
    3308,65,
    3373,257,
    3379,129,
    3388,65,
    3404,65,
    3430,65,
    3456,65,
    3520,257,
    3535,65,
    3552,65,
    3578,65,
    3604,65,
    3667,257,
    3683,65,
    3700,65,
    3726,65,
    3752,65,
    3814,257,
    3830,65,
    3848,65,
    3874,65,
    3900,65,
    3961,257,
    3978,65,
    3996,65,
    4022,65,
    4048,65,
    4108,257,
    4125,65,
    4144,65,
    4170,65,
    4196,65,
    4255,257,
    4273,65,
    4292,65,
    4318,65,
    4344,65,
    4402,257,
    4420,65,
    4440,65,
    4466,65,
    4492,65,
    4549,257,
    4588,65,
    4614,65,
    4640,65,
    4697,193,
    4702,129,
    4736,65,
    4762,65,
    4788,65,
    4844,193,
    4849,129,
    4884,65,
    4910,65,
    4936,65,
    4991,193,
    4996,129,
    5032,65,
    5058,65,
    5084,65,
    5138,193,
    5143,129,
    5180,65,
    5206,65,
    5232,65,
    5285,193,
    5290,129,
    5328,65,
    5354,65,
    5380,65,
    5432,193,
    5437,129,
    5440,65,
    5450,65,
    5476,65,
    5502,65,
    5578,257,
    5587,65,
    5598,65,
    5624,65,
    5650,65,
    5725,257,
    5735,65,
    5746,65,
    5772,65,
    5798,65,
    5872,257,
    5882,65,
    5894,65,
    5920,65,
    5946,65,
    6019,257,
    6030,65,
    6042,65,
    6068,65,
    6094,65,
    6166,257,
    6177,65,
    6190,65,
    6216,65,
    6242,65,
    6313,257,
    6325,65,
    6338,65,
    6364,65,
    6390,65,
    6460,257,
    6466,129,
    6472,65,
    6486,65,
    6512,65,
    6538,65,
    6607,257,
    6613,129,
    6620,65,
    6634,65,
    6660,65,
    6686,65,
    6754,257,
    6760,129,
    6767,65,
    6782,65,
    6808,65,
    6834,65,
    6901,257,
    6907,129,
    6915,65,
    6930,65,
    6956,65,
    6982,65,
    7048,257,
    7054,129,
    7062,65,
    7078,65,
    7104,65,
    7130,65,
    7195,257,
    7201,129,
    7210,65,
    7226,65,
    7252,65,
    7278,65,
    7342,257,
    7357,65,
    7374,65,
    7400,65,
    7426,65,
    7489,257,
    7505,65,
    7522,65,
    7548,65,
    7574,65,
    7636,257,
    7652,65,
    7670,65,
    7696,65,
    7722,65,
    7783,257,
    7800,65,
    7818,65,
    7844,65,
    7870,65,
    7930,257,
    7947,65,
    7966,65,
    7992,65,
    8018,65,
    8077,257,
    8095,65,
    8114,65,
    8140,65,
    8166,65,
    8224,257,
    8242,65,
    8262,65,
    8288,65,
    8314,65,
    8371,257,
    8410,65,
    8436,65,
    8462,65,
    8519,193,
    8524,129,
    8558,65,
    8584,65,
    8610,65,
    8666,193,
    8671,129,
    8706,65,
    8732,65,
    8758,65,
    8813,193,
    8818,129,
    8854,65,
    8880,65,
    8906,65,
    8960,193,
    8965,129,
    9002,65,
    9028,65,
    9054,65,
    9107,193,
    9112,129,
    9150,65,
    9176,65,
    9202,65,
    9254,193,
    9259,129,
    9262,65,
    9272,65,
    9298,65,
    9324,65,
    9400,257,
    9409,65,
    9420,65,
    9446,65,
    9472,65,
    9547,257,
    9557,65,
    9568,65,
    9594,65,
    9620,65,
    9694,257,
    9704,65,
    9716,65,
    9742,65,
    9768,65,
    9841,257,
    9852,65,
    9864,65,
    9890,65,
    9916,65,
    9988,257,
    9999,65,
    10012,65,
    10038,65,
    10064,65,
    10135,257,
    10147,65,
    10160,65,
    10186,65,
    10212,65,
    10282,257,
    10288,129,
    10294,65,
    10308,65,
    10334,65,
    10360,65,
    10429,257,
    10435,129,
    10442,65,
    10456,65,
    10482,65,
    10508,65,
    10576,257,
    10582,129,
    10589,65,
    10604,65,
    10630,65,
    10656,65,
    10723,257,
    10729,129,
    10737,65,
    10752,65,
    10778,65,
    10804,65,
    10870,257,
    10876,129,
    10884,65,
    10900,65,
    10926,65,
    10952,65,
    11017,257,
    11023,129,
    11032,65,
    11048,65,
    11074,65,
    11100,65,
    11164,257,
    11179,65,
    11196,65,
    11222,65,
    11248,65,
    11311,257,
    11327,65,
    11344,65,
    11370,65,
    11396,65,
    11458,257,
    11474,65,
    11492,65,
    11518,65,
    11544,65,
    11605,257,
    11622,65,
    11640,65,
    11666,65,
    11692,65,
    11752,257,
    11769,65,
    11788,65,
    11814,65,
    11840,65,
    11899,257,
    11917,65,
    11936,65,
    11962,65,
    11988,65,
    12046,257,
    12064,65,
    12084,65,
    12110,65,
    12136,65,
    12193,257,
    12232,65,
    12258,65,
    12284,65,
    12341,193,
    12346,129,
    12380,65,
    12406,65,
    12432,65,
    12488,193,
    12493,129,
    12528,65,
    12554,65,
    12580,65,
    12635,193,
    12640,129,
    12676,65,
    12702,65,
    12728,65,
    12782,193,
    12787,129,
    12824,65,
    12850,65,
    12876,65,
    12929,193,
    12934,129,
    12972,65,
    12998,65,
    13024,65,
    13076,193,
    13081,129,
    13172,65,
    13188,129,
    13226,193,
    13320,65,
    13337,129,
    13373,193,
    13468,65,
    13486,129,
    13520,193,
    13616,65,
    13635,129,
    13667,193,
    13764,65,
    13784,129,
    13814,193,
    13912,65,
    13933,129,
    13961,193,
    14060,65,
    14082,129,
    14108,193,
    14208,65,
    14231,129,
    14255,193,
    14356,65,
    14380,129,
    14402,193,
    14504,65,
    14529,129,
    14549,193,
    14652,65,
    14678,129,
    14696,193,
    14800,65,
    14827,129,
    14843,193,
    14948,65,
    14976,129,
    14990,193,
    15096,65,
    15125,129,
    15137,193,
    15244,65,
    15274,129,
    15284,193,
    15392,65,
    15423,129,
    15431,193,
    15524,65,
    15540,65,
    15578,193,
    15671,65,
    15688,65,
    15725,193,
    15819,65,
    15836,65,
    15872,193,
    15966,65,
    15984,65,
    16019,193,
    16114,65,
    16132,65,
    16166,193,
    16261,65,
    16280,65,
    16313,193,
    16409,65,
    16428,65,
    16460,193,
    16556,65,
    16576,65,
    16607,193,
    16704,65,
    16724,65,
    16754,193,
    16851,65,
    16872,65,
    16901,193,
    16999,65,
    17020,65,
    17048,193,
    17146,65,
    17168,65,
    17195,193,
    17294,65,
    17316,65,
    17342,193,
    17441,65,
    17464,65,
    17489,193,
    17589,65,
    17612,65,
    17636,193,
    17736,65,
    17760,65,
    17783,193,
    17884,65,
    17908,65,
    17930,193,
    18031,65,
    18056,65,
    18077,193,
    18179,65,
    18204,65,
    18224,193,
    18326,65,
    18352,65,
    18371,193,
    18474,65,
    18500,65,
    18518,193,
    18621,65,
    18648,65,
    18665,193,
    18769,65,
    18796,65,
    18812,193,
    18916,65,
    18944,65,
    18959,193,
    19064,65,
    19092,65,
    19106,193,
    19211,65,
    19240,65,
    19253,193,
    19359,65,
    19388,65,
    19400,193,
    19506,65,
    19536,65,
    19547,193,
    19654,65,
    19684,65,
    19694,193,
    19801,65,
    19832,65,
    19841,193,
    19949,65,
    19980,65,
    19988,193,
    20096,65,
    20128,65,
    20135,193,
    20276,65,
    20284,65,
    20424,65,
    20431,65,
    20434,1921,
    20470,1281,
    20496,1281,
    20572,257,
    20578,129,
    20581,642,
    20591,4993,
    20719,66,
    20720,193,
    20725,129,
    20728,642,
    20738,4993,
    20866,66,
    20867,193,
    20872,129,
    20875,642,
    20885,4993,
    21013,66,
    21014,193,
    21019,129,
    21110,3073,
    21164,193,
    21257,1026,
    21273,2049,
    21311,66,
    21312,65,
    21313,66,
    21319,194,
    21332,385,
    21346,385,
    21358,385,
    21372,385,
    21384,385,
    21398,3585,
    21454,66,
    21455,449,
    21466,194,
    21479,385,
    21493,385,
    21505,385,
    21519,385,
    21531,385,
    21545,385,
    21601,66,
    21602,193,
    21607,129,
    };
  };

  public int[] getRegsetTypeTbl() {
    return new int[] {
    -1,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    514,
    514,
    1026,
    514,
    258,
    130,
    1028,
    516,
    514,
    514,
    };
  }
}
