package coins.backend.gen;

import coins.backend.Storage;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;

public class MachineParams_x86sse2 extends coins.backend.MachineParams {

  public int nRegisters() { return 50; }
  public int nRegsets() { return 67; }

  public int typeAddress() { return 514; }
  public int typeBool() { return 514; }
  public String[] getSymName() {
    return new String[]{
      "%edxeax",
      "%ebxecx",
      "%ediesi",
      "%eax",
      "%ecx",
      "%edx",
      "%ebx",
      "%esi",
      "%edi",
      "%ecx_",
      "%edx_",
      "%ax",
      "%cx",
      "%dx",
      "%bx",
      "%si",
      "%di",
      "%al",
      "%ah",
      "%cl",
      "%ch",
      "%dl",
      "%dh",
      "%bl",
      "%bh",
      "%xmm0",
      "%xmm1",
      "%xmm2",
      "%xmm3",
      "%xmm4",
      "%xmm5",
      "%xmm6",
      "%xmm7",
      "%f0",
      "%f1",
      "%f2",
      "%f3",
      "%f4",
      "%t0",
      "%t1",
      "%t2",
      "%t3",
      "%t4",
      "%t5",
      "%t6",
      "%t7",
      "%ebp",
      "%esp",
      "%xmm0/F32/0",
      "%xmm1/F32/0",
      "%xmm2/F32/0",
      "%xmm3/F32/0",
      "%xmm4/F32/0",
      "%xmm5/F32/0",
      "%xmm6/F32/0",
      "%t0/F32/0",
      "%t1/F32/0",
      "%t2/F32/0",
      "%t3/F32/0",
      "%t4/F32/0",
      "%t5/F32/0",
      "%t6/F32/0",
      "%t7/F32/0",
    };
  };
  public int[] getSymType() {
    return new int[] {
      1026,
      1026,
      1026,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      258,
      258,
      258,
      258,
      258,
      258,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      514,
      514,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
    };
  };
  public int[] getSymRegNumber() {
    return new int[] {
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      0,
      0,
      10,
      11,
      12,
      13,
      14,
      15,
      16,
      0,
      17,
      0,
      18,
      0,
      19,
      0,
      20,
      21,
      22,
      23,
      24,
      25,
      26,
      0,
      0,
      0,
      0,
      0,
      0,
      34,
      35,
      36,
      37,
      38,
      39,
      40,
      41,
      0,
      0,
      27,
      28,
      29,
      30,
      31,
      32,
      33,
      42,
      43,
      44,
      45,
      46,
      47,
      48,
      49,
    };
  };

  public short[][] getOverlapReg() {
    return new short[][] { {},
  /* 1: */ {4,6,10,12,16,18,},
  /* 2: */ {5,7,11,13,17,19,},
  /* 3: */ {8,9,14,15,},
  /* 4: */ {1,10,16,},
  /* 5: */ {2,11,17,},
  /* 6: */ {1,12,18,},
  /* 7: */ {2,13,19,},
  /* 8: */ {3,14,},
  /* 9: */ {3,15,},
  /* 10: */ {1,4,16,},
  /* 11: */ {2,5,17,},
  /* 12: */ {1,6,18,},
  /* 13: */ {2,7,19,},
  /* 14: */ {3,8,},
  /* 15: */ {3,9,},
  /* 16: */ {1,4,10,},
  /* 17: */ {2,5,11,},
  /* 18: */ {1,6,12,},
  /* 19: */ {2,7,13,},
  /* 20: */ {27,},
  /* 21: */ {28,},
  /* 22: */ {29,},
  /* 23: */ {30,},
  /* 24: */ {31,},
  /* 25: */ {32,},
  /* 26: */ {33,},
  /* 27: */ {20,},
  /* 28: */ {21,},
  /* 29: */ {22,},
  /* 30: */ {23,},
  /* 31: */ {24,},
  /* 32: */ {25,},
  /* 33: */ {26,},
  /* 34: */ {42,},
  /* 35: */ {43,},
  /* 36: */ {44,},
  /* 37: */ {45,},
  /* 38: */ {46,},
  /* 39: */ {47,},
  /* 40: */ {48,},
  /* 41: */ {49,},
  /* 42: */ {34,},
  /* 43: */ {35,},
  /* 44: */ {36,},
  /* 45: */ {37,},
  /* 46: */ {38,},
  /* 47: */ {39,},
  /* 48: */ {40,},
  /* 49: */ {41,},
    };
  };

  public short[][] getSuperReg() {
    return new short[][] { {},
  /* 1: */ {},
  /* 2: */ {},
  /* 3: */ {},
  /* 4: */ {1,},
  /* 5: */ {2,},
  /* 6: */ {1,},
  /* 7: */ {2,},
  /* 8: */ {3,},
  /* 9: */ {3,},
  /* 10: */ {1,4,},
  /* 11: */ {2,5,},
  /* 12: */ {1,6,},
  /* 13: */ {2,7,},
  /* 14: */ {3,8,},
  /* 15: */ {3,9,},
  /* 16: */ {1,4,10,},
  /* 17: */ {2,5,11,},
  /* 18: */ {1,6,12,},
  /* 19: */ {2,7,13,},
  /* 20: */ {},
  /* 21: */ {},
  /* 22: */ {},
  /* 23: */ {},
  /* 24: */ {},
  /* 25: */ {},
  /* 26: */ {},
  /* 27: */ {20,},
  /* 28: */ {21,},
  /* 29: */ {22,},
  /* 30: */ {23,},
  /* 31: */ {24,},
  /* 32: */ {25,},
  /* 33: */ {26,},
  /* 34: */ {},
  /* 35: */ {},
  /* 36: */ {},
  /* 37: */ {},
  /* 38: */ {},
  /* 39: */ {},
  /* 40: */ {},
  /* 41: */ {},
  /* 42: */ {34,},
  /* 43: */ {35,},
  /* 44: */ {36,},
  /* 45: */ {37,},
  /* 46: */ {38,},
  /* 47: */ {39,},
  /* 48: */ {40,},
  /* 49: */ {41,},
    };
  };

  public short[][] getSubReg() {
    return new short[][] { {},
  /* 1: */ {4,6,10,12,16,18,},
  /* 2: */ {5,7,11,13,17,19,},
  /* 3: */ {8,9,14,15,},
  /* 4: */ {10,16,},
  /* 5: */ {11,17,},
  /* 6: */ {12,18,},
  /* 7: */ {13,19,},
  /* 8: */ {14,},
  /* 9: */ {15,},
  /* 10: */ {16,},
  /* 11: */ {17,},
  /* 12: */ {18,},
  /* 13: */ {19,},
  /* 14: */ {},
  /* 15: */ {},
  /* 16: */ {},
  /* 17: */ {},
  /* 18: */ {},
  /* 19: */ {},
  /* 20: */ {27,},
  /* 21: */ {28,},
  /* 22: */ {29,},
  /* 23: */ {30,},
  /* 24: */ {31,},
  /* 25: */ {32,},
  /* 26: */ {33,},
  /* 27: */ {},
  /* 28: */ {},
  /* 29: */ {},
  /* 30: */ {},
  /* 31: */ {},
  /* 32: */ {},
  /* 33: */ {},
  /* 34: */ {42,},
  /* 35: */ {43,},
  /* 36: */ {44,},
  /* 37: */ {45,},
  /* 38: */ {46,},
  /* 39: */ {47,},
  /* 40: */ {48,},
  /* 41: */ {49,},
  /* 42: */ {},
  /* 43: */ {},
  /* 44: */ {},
  /* 45: */ {},
  /* 46: */ {},
  /* 47: */ {},
  /* 48: */ {},
  /* 49: */ {},
    };
  };

  public String[] getRegsetName() {
    return new String[] {
      "*reg-edxeax-I64*",
      "*reg-ebxecx-I64*",
      "*reg-eax-I32*",
      "*reg-ecx-I32*",
      "*reg-edx-I32*",
      "*reg-ax-I16*",
      "*reg-cx-I16*",
      "*reg-al-I8*",
      "*reg-cl-I8*",
      "*reg-I64*",
      "*reg-I32*",
      "*reg-I16*",
      "*reg-I8*",
      "*reg-F64X*",
      "*reg-F32X*",
      "*reg-tmp-F64*",
      "*reg-tmp-F32*",
      "*reg-bytable-I64*",
      "*reg-bytable-I32*",
      "*reg-bytable-I16*",
      "*reg-call-clobbers*",
      "*reg-callee-saves*",
      "*reg-mod$2-I32*",
    };
  };
  public int[] getRegsetNumber() {
    return new int[] {
      1,
      2,
      4,
      5,
      6,
      10,
      11,
      16,
      17,
      50,
      51,
      52,
      53,
      54,
      55,
      56,
      57,
      58,
      59,
      60,
      61,
      62,
      63,
    };
  };
  public short[][] getRegsetMap() {
    return new short[][] {
      {1,2,3,},
      {4,5,6,7,8,9,},
      {10,11,12,13,14,15,},
      {16,17,18,19,},
      {20,21,22,23,24,25,26,},
      {27,28,29,30,31,32,33,},
      {34,35,36,37,38,39,40,41,},
      {42,43,44,45,46,47,48,49,},
      {1,2,},
      {4,5,6,7,},
      {10,11,12,13,},
      {4,5,6,},
      {7,8,9,20,21,22,23,24,25,26,},
      {4,5,7,8,9,},
      {7,8,9,},
      {4,5,7,},
      {4,5,},
    };
  };

  public short[] getRegsetNAvail() {
    return new short[] {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      3, 6, 6, 4, 7, 7, 8, 8, 2, 4, 
      4, 3, 10, 5, 3, 3, 2,     };
  };

  public int[] getCompAndTbl() {
    return new int[] {
      -1226,1,2,3,
      -1279,4,5,6,7,8,9,
      -1336,10,11,12,13,14,15,
      -1394,16,17,18,19,
      -1451,20,21,22,23,24,25,26,
      -1512,27,28,29,30,31,32,33,
      -1574,34,35,36,37,38,39,40,41,
      -1638,42,43,44,45,46,47,48,49,
      -1654,1,2,
      -1703,58,
      -1715,4,5,6,7,
      -1762,59,
      -1780,10,11,12,13,
      -1822,60,
      -1834,4,5,6,
      -1881,61,
      -1889,61,
      -1898,7,8,9,
      -1911,20,21,22,23,24,25,26,
      -1942,64,
      -1945,54,
      -1950,7,
      -1957,4,5,
      -1960,7,8,9,
      -2004,63,
      -2012,65,
      -2014,66,64,
      -2023,7,8,9,
      -2067,64,
      -2075,7,
      -2078,64,64,
      -2084,4,5,
      -2087,7,
      -2131,65,
      -2139,65,
      -2141,66,7,65,7,
      -2149,4,5,
      -2196,66,
      -2204,66,
      -2206,66,
      -2208,66,
      -2210,66,    };
  };

  public int[] getCompWeightTbl() {
    return new int[] {
    68,65,
    71,65,
    73,65,
    77,65,
    79,65,
    83,65,
    85,65,
    117,257,
    125,257,
    130,65,
    132,129,
    136,65,
    139,65,
    141,65,
    145,65,
    147,65,
    151,65,
    153,65,
    184,257,
    192,577,
    204,65,
    209,129,
    215,129,
    251,193,
    263,193,
    269,65,
    272,65,
    278,65,
    284,65,
    318,257,
    326,257,
    331,65,
    333,129,
    337,65,
    340,65,
    346,65,
    352,65,
    385,257,
    393,257,
    398,65,
    400,129,
    403,65,
    408,65,
    414,65,
    420,65,
    452,257,
    460,257,
    471,65,
    476,65,
    482,65,
    488,65,
    519,257,
    527,193,
    531,257,
    539,65,
    544,65,
    550,65,
    586,193,
    598,193,
    606,65,
    612,65,
    618,65,
    653,193,
    665,193,
    671,65,
    674,65,
    680,65,
    686,65,
    720,257,
    728,257,
    733,65,
    735,129,
    739,65,
    742,65,
    748,65,
    754,65,
    787,257,
    795,257,
    800,65,
    802,129,
    805,65,
    810,65,
    816,65,
    822,65,
    854,257,
    862,257,
    873,65,
    878,65,
    884,65,
    890,65,
    921,257,
    929,193,
    933,257,
    941,65,
    946,65,
    952,65,
    988,193,
    1000,193,
    1008,65,
    1014,65,
    1020,65,
    1055,193,
    1067,193,
    1073,65,
    1076,65,
    1082,65,
    1088,65,
    1122,257,
    1130,257,
    1135,65,
    1137,129,
    1141,65,
    1144,65,
    1150,65,
    1156,65,
    1189,257,
    1197,257,
    1202,65,
    1204,129,
    1207,65,
    1212,65,
    1218,65,
    1224,65,
    1256,257,
    1264,257,
    1275,65,
    1280,65,
    1286,65,
    1292,65,
    1323,257,
    1331,193,
    1335,257,
    1360,65,
    1367,65,
    1394,129,
    1402,65,
    1428,65,
    1435,65,
    1461,129,
    1469,65,
    1496,65,
    1503,65,
    1528,129,
    1536,65,
    1564,65,
    1571,65,
    1595,129,
    1603,65,
    1632,65,
    1639,65,
    1662,129,
    1670,65,
    1700,65,
    1707,65,
    1729,129,
    1737,65,
    1768,65,
    1775,65,
    1796,129,
    1804,65,
    1829,65,
    1836,65,
    1863,129,
    1871,65,
    1897,65,
    1904,65,
    1930,129,
    1938,65,
    1965,65,
    1972,65,
    1997,129,
    2005,65,
    2033,65,
    2040,65,
    2064,129,
    2072,65,
    2101,65,
    2108,65,
    2131,129,
    2139,65,
    2169,65,
    2176,65,
    2198,129,
    2206,65,
    2237,65,
    2244,65,
    2265,129,
    2273,65,
    2312,65,
    2320,65,
    2334,129,
    2380,65,
    2388,65,
    2401,129,
    2448,65,
    2456,65,
    2468,129,
    2516,65,
    2524,65,
    2535,129,
    2584,65,
    2592,65,
    2602,129,
    2652,65,
    2660,65,
    2669,129,
    2720,65,
    2728,65,
    2736,129,
    2788,65,
    2796,65,
    2803,129,
    2848,65,
    2856,65,
    2870,129,
    2916,65,
    2924,65,
    2937,129,
    2984,65,
    2992,65,
    3004,129,
    3052,65,
    3060,65,
    3071,129,
    3120,65,
    3128,65,
    3138,129,
    3188,65,
    3196,65,
    3205,129,
    3256,65,
    3264,65,
    3272,129,
    3324,65,
    3332,65,
    3339,129,
    3351,1217,
    3400,257,
    3408,577,
    3418,194,
    3421,1025,
    3467,66,
    3468,193,
    3475,66,
    3476,513,
    3485,194,
    3488,1025,
    3534,66,
    3535,193,
    3542,66,
    3543,513,
    3552,130,
    3555,257,
    3561,257,
    3567,257,
    3601,66,
    3602,193,
    3609,66,
    3610,513,
    3638,897,
    3672,129,
    3680,65,
    3705,897,
    3739,129,
    3747,65,
    3786,1025,
    3808,129,
    3853,1025,
    3875,129,
    3887,129,
    3890,257,
    3896,257,
    3902,257,
    3936,257,
    3944,577,
    3954,130,
    3957,257,
    3963,257,
    3969,257,
    4003,66,
    4004,193,
    4011,66,
    4012,513,
    4021,130,
    4024,257,
    4030,257,
    4036,257,
    4070,66,
    4071,193,
    4078,66,
    4079,513,
    4088,66,
    4089,65,
    4091,193,
    4097,193,
    4103,193,
    4137,66,
    4138,193,
    4145,66,
    4146,193,
    4150,65,
    4152,129,
    4156,65,
    4157,66,
    4161,193,
    4167,193,
    4173,961,
    4204,66,
    4205,321,
    4212,193,
    4216,257,
    4222,65,
    4223,130,
    4225,129,
    4228,321,
    4234,321,
    4240,65,
    4271,66,
    4272,193,
    4279,66,
    4280,513,
    4290,65,
    4291,66,
    4295,193,
    4301,193,
    4307,65,
    4338,66,
    4339,193,
    4346,193,
    4350,257,
    4356,65,
    4357,66,
    4359,129,
    4362,65,
    4365,129,
    4368,65,
    4371,129,
    4374,65,
    4405,66,
    4406,193,
    4413,66,
    4414,513,
    4423,129,
    4426,129,
    4432,129,
    4438,129,
    4472,257,
    4480,257,
    4485,65,
    4487,129,
    };
  };

  public int[] getRegsetTypeTbl() {
    return new int[] {
    -1,
    1026,
    1026,
    1026,
    514,
    514,
    514,
    514,
    514,
    514,
    258,
    258,
    258,
    258,
    258,
    258,
    130,
    130,
    130,
    130,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    1026,
    514,
    258,
    130,
    1028,
    516,
    1028,
    516,
    1026,
    514,
    258,
    514,
    514,
    514,
    514,
    514,
    514,
    };
  }
}
