package coins.backend.lir;

import java.lang.*;
import coins.backend.*;
import coins.backend.cfg.*;

/** Represents Phi node. */
public class LirPhi extends LirNode implements LirDef {
  LirNode dst;
  LirNode src[];
  BasicBlk blk[];

  LirPhi(int id, int t, LirNode d, LirNode s[], BasicBlk b[]) {
    super(id, OP_PHI, t);
    dst = d;
    src = s;
    blk = b;
  }

  public int nSrcs() { return src.length; }

  public LirNode src(int n) { return src[n]; }

  public LirNode dst() { return dst; }

  public BasicBlk blk(int n) { return blk[n]; }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

}
