package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.sym.*;

/** STATIC/FRAME/REG LirNode */
public class LirSymRef extends LirNode implements LirDef {
  public final Symbol symbol;

  LirSymRef(int id, int op, int t, Symbol sym) {
    super(id, op, t);
    symbol = sym;
  }

  public String toString() {
    return "(" + OpTable.toName(opCode)
      + TypePrefix + LType.toString(type)
      + " \"" + symbol.name + "\")";
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
