// DO NOT EDIT THIS FILE DIRECTLY; Edit LirOpTable.pattern instead.
package coins.backend.lir;

import java.lang.*;
import java.util.*;
import coins.backend.*;

/** Operator mnemonic code dictionary. */
public class OpTable implements LirDef {
  static String[] opNames = {
    "dummy",
    "INTCONST",
    "FLOATCONST",
    "STATIC",
    "FRAME",
    "REG",
    "SUBREG",
    "LABEL",
    "NEG",
    "ADD",
    "SUB",
    "MUL",
    "DIVS",
    "DIVU",
    "MODS",
    "MODU",
    "CONVSX",
    "CONVZX",
    "CONVIT",
    "CONVFX",
    "CONVFT",
    "CONVFI",
    "CONVSF",
    "CONVUF",
    "BAND",
    "BOR",
    "BXOR",
    "BNOT",
    "LSHS",
    "LSHU",
    "RSHS",
    "RSHU",
    "TSTEQ",
    "TSTNE",
    "TSTLTS",
    "TSTLES",
    "TSTGTS",
    "TSTGES",
    "TSTLTU",
    "TSTLEU",
    "TSTGTU",
    "TSTGEU",
    "ASMCONST",
    "PURE",
    "MEM",
    "SET",
    "JUMP",
    "JUMPC",
    "JUMPN",
    "DEFLABEL",
    "CALL",
    "PROLOGUE",
    "EPILOGUE",
    "PHI",
    "PARALLEL",
    "USE",
    "CLOBBER",
    "LIST",
    "SETMEM",

  };

  private static final Map table;

  static {
    // initialize name table
    table = new HashMap();
    for (int i = 0; i < OP_MAX; i++)
      table.put(opNames[i], new Integer(i));
  }

  /** Convert operator mnemonic to integer code */
  public static int toCode(String name) {
    Integer code = (Integer)table.get(name);
    if (code == null)
      throw new Error("Unknown opcode: " + name);
    return code.intValue();
  }

  /** Convert operator code to mnemonic */
  public static String toName(int code) {
    return opNames[code];
  }
}
