package coins.backend.lir;

import coins.backend.*;

/** Represents binary operators */
public class LirBinOp extends LirNode {
  LirNode src0, src1;

  public LirBinOp(int id, int op, int t, LirNode operand0, LirNode operand1) {
    super(id, op, t);
    src0 = operand0;
    src1 = operand1;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.operator(opCode, type, src0.makeCopy(fac), src1.makeCopy(fac));
  }

  public int nSrcs() { return 2; }

  public LirNode src(int n) {
    if (n == 0)
      return src0;
    else if (n == 1)
      return src1;
    else
      throw new IllegalArgumentException();
  }

  public void setSrc(int n, LirNode x) {
    if (n == 0)
      src0 = x;
    else if (n == 1)
      src1 = x;
    else
      throw new IllegalArgumentException();
  }

  public boolean equals(Object x) {
    return (x instanceof LirBinOp && super.equals(x)
            && src0.equals(((LirBinOp)x).src0) && src1.equals(((LirBinOp)x).src1));
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }

}
