package coins.backend.lir;

import coins.backend.*;
import coins.backend.sym.*;
import coins.backend.cfg.*;

/**
 * Generate LIR nodes.
 */
public interface LirFactory {

  /** Return upper bound of LirNode id numbers. */
  public int idBound();

  /** Create FLOATCONST node */
  public LirNode fconst(int type, double value);

  /** Create INTCONST node */
  public LirNode iconst(int type, long value);

  /** Create STATIC/FRAME/REG node */
  public LirNode symRef(int opCode, int type, Symbol symbol);

  /** Create SUBREG node */
  public LirNode subReg(int opCode, int type, LirNode src, int pos);

  /** Create LABEL node */
  public LirNode labelRef(int opCode, int type, Label label);

  /** Create unary operator node */
  public LirNode operator(int opCode, int type, LirNode operand);

  /** Create binary operator node */
  public LirNode operator(int opCode, int type, LirNode operand0, LirNode operand1);

  /** Create ternary operator node */
  public LirNode operator(int opCode, int type, LirNode operand0,
                          LirNode operand1, LirNode operand2);

  /** Create n-ary operator node */
  public LirNode operator(int opCode, int type, LirNode operands[]);

  /** Make a copy of node */
  public LirNode makeCopy(LirNode inst);
}
