package coins.backend.sym;

import java.io.*;
import coins.backend.*;
import coins.backend.lir.*;
import coins.backend.cfg.*;

/** Label */
public class Label {
  /** Label name */
  public final String name;

  LirNode refNode;

  /** The basic block this label belongs to. */
  BasicBlk basicBlk;

  /** Create label with name n. */
  public Label(String n) { name = n; }

  /** Return the basic block. */
  public BasicBlk basicBlk() {
    if (basicBlk == null)
      throw new Error("label \"" + name + "\" undefined.");
    return basicBlk;
  }

  /** Set the basic block. */
  public void setBasicBlk(BasicBlk b) { basicBlk = b; }


  /** Set LirNode which refers to this label */
  public void setRefNode(LirNode node) {
    refNode = node;
  }

  /** Return LirNode which refers to this label */
  public LirNode refNode() {
    return refNode;
  }


  /** Visualize */
  public String toString() {
    if (basicBlk == null)
      return name;
    else
      return basicBlk.label().name;
  }
}
