package coins.backend.sym;

import java.io.*;
import coins.backend.*;

/** Symbol table entry for automatic objects */
public class SymAuto extends Symbol {
  /** Offset of the FRAME object */
  public final int offset;

  /** Create automatic objects' symbol entry. Only SymTab calls. */
  SymAuto(String name, int id, int storage, int type, int boundary,
          int offset) {
    super(name, id, storage, type, boundary);
    this.offset = offset;
  }

  /** Visualize */
  public String toString() {
    return "(\"" + name + "\" " + Storage.toString(storage)
      + " " + Type.toString(type) + " " + boundary + " " + offset
      + flagsToString()
      + (shadow != null ? " &shadow=\"" + shadow.name + "\"" : "")
      + ")";
  }
}
