package coins.backend.sym;

import java.io.*;
import coins.backend.*;
import coins.backend.lir.*;

/** Symbol table entry */
public abstract class Symbol {
  public final String name;
  public final int id;
  public final int storage;
  public final int type;
  public final int boundary;

  LirNode refNode;

  /** Miscellaneous flags */
  int flags;

  /** Register objects' original variable */
  Symbol shadow;

  /** This variable was taken its address. */
  public static final int F_ADDRTAKEN = 1;

  Symbol(String name, int id, int storage, int type, int boundary) {
    this.name = name;
    this.id = id;
    this.storage = storage;
    this.type = type;
    this.boundary = boundary;
  }

  /** Test if the given flag is up.
   *  (true returned when the flag is up) */
  public boolean testFlag(int flag) {
    return ((flags & flag) != 0);
  }

  /** Set flag 0 or 1 */
  public void setFlag(int flag, boolean yes) {
    if (yes)
      flags |= flag;
    else
      flags &= ~flag;
  }

  /** Visualize flags field. */
  String flagsToString() {
    return (flags & F_ADDRTAKEN) != 0 ? " &addrtaken" : "";
  }

  /** Return the shadow variable (original/register variable) */
  public Symbol shadow() { return shadow; }

  /** Set original/shadow variable */
  public void setShadow(Symbol another) {
    shadow = another;
  }

  /** Set LirNode which refers to this symbol */
  public void setRefNode(LirNode node) {
    refNode = node;
  }

  /** Return LirNode which refers to this symbol */
  public LirNode refNode() {
    return refNode;
  }

  public abstract String toString();
}
