package coins.backend.sym;

import java.io.*;
import coins.backend.*;
import coins.backend.cfg.*;

/** Label */
public class Label {
  /** Label name */
  public final String name;

  /** The basic block this label belongs to. */
  BasicBlk basicBlk;

  /** Create label with name n. */
  public Label(String n) { name = n; }

  /** Return the basic block. */
  public BasicBlk basicBlk() {
    if (basicBlk == null)
      throw new Error("label \"" + name + "\" undefined.");
    return basicBlk;
  }

  /** Set the basic block. */
  public void setBasicBlk(BasicBlk b) { basicBlk = b; }

  /** Visualize */
  public String toString() {
    if (basicBlk == null)
      return name;
    else
      return basicBlk.label().name;
  }
}
