package coins.backend.sym;

import java.io.*;
import coins.backend.*;

/** Symbol table entry for static objects */
public class SymStatic extends Symbol {
  /** Segment name */
  public final String segment;

  /** Indicates whether external or internal */
  public final String linkage;

  /** Body of the function. */
  Function body;

  /** Create static objects' symbol entry. Only SymTab calls. */
  SymStatic(String aName, int aStorage, int aType, int aBoundary,
            String aSegment, String aLinkage) {
    super(aName, aStorage, aType, aBoundary);
    segment = aSegment;
    linkage = aLinkage;
  }

  /** Return body */
  public Function body() { return body; }

  /** Set function body */
  public void setBody(Function func) { body = func; }

  /** Visualize */
  public String toString() {
    return "(\"" + name + "\" " + Storage.toString(storage)
      + " " + Type.toString(type)
      + " " + boundary + " " + segment + " " + linkage
      + flagsToString() + ")";
  }
}
