package coins.backend.sym;

import java.io.*;
import java.util.*;
import coins.backend.*;
import coins.backend.util.*;

/** Symbol table. */
public class SymTab {
  private Map table = new HashMap();
  private BiList list = new BiList();

  /** Create empty symbol table. */
  public SymTab() {}

  /** Register STATIC symbol entry. */
  public Symbol addSymbol(String name, int storage, int type,
                        int boundary, String segment, String linkage) {
    Symbol sym = new SymStatic(name, storage, type, boundary, segment, linkage);
    table.put(name, sym);
    list.add(sym);
    return sym;
  }

  /** Register FRAME/REG symbol entry. */
  public Symbol addSymbol(String name, int storage, int type,
                        int boundary, int offset) {
    Symbol sym = new SymAuto(name, storage, type, boundary, offset);
    table.put(name, sym);
    list.add(sym);
    return sym;
  }

  /** Find a symbol with key <code>name</code>. */
  public Symbol get(String name) { return (Symbol)table.get(name); }

  /** Return the list of symbol entries. */
  public BiList symbols() { return list; }

  /** Return an iterator for accessing symbol entries. */
  public Iterator iterator() { return list.iterator(); }

  /** Dump symbol table */
  public void printIt(PrintWriter out) {
    out.println("Symbol table:");
    for (BiLink p = list.first(); !p.atEnd(); p = p.next()) {
      out.println("  " + ((Symbol)p.elem()).toString());
    }
  }
}
