
import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.util.*;

/**
 * Standalone back end of COINS compiler
 */
public class BackDriver {

  public static void main(String[] args) throws IOException {
    boolean doCodeGen = false;

    // Check options
    int ai = 0;
    while (ai < args.length) {
      if (args[ai].equals("-g")) {
        doCodeGen = true;
        ai++;
      }
      else
        break;
    }
    if (ai + 1 != args.length) {
      System.err.println("java BackEnd lirfile");
      return;
    }

    PushbackReader stdin
      = new PushbackReader(new InputStreamReader(new FileInputStream(args[ai])));
    PrintWriter stdout = new PrintWriter(System.out, true);
    Object sexp;
    OutputStream codeFile = System.out;
    BackEnd backendSession = new BackEnd(doCodeGen, stdout);

    try {
      while ((sexp = ImList.readSexp(stdin)) != null) {
        backendSession.doIt((ImList)sexp, codeFile);
      }
    } catch (SyntaxError e) {
      throw new RuntimeException("Syntax error: " + e.getMessage());
    }
  }
}
