package coins.backend.lir;

import coins.backend.*;
import coins.backend.util.*;
import coins.backend.sym.*;
import coins.backend.cfg.*;

/**
 * Generate LIR nodes.
 */
public interface LirFactory {

  /** Return upper bound of LirNode id numbers. */
  public int idBound();

  /** Create FLOATCONST node */
  public LirNode fconst(int type, double value, ImList opt);

  /** Create INTCONST node */
  public LirNode iconst(int type, long value, ImList opt);

  /** Create STATIC/FRAME/REG node */
  public LirNode symRef(int opCode, int type, Symbol symbol, ImList opt);

  /** Create STATIC/FRAME/REG node, short form */
  public LirNode symRef(Symbol symbol);

  /** Create SUBREG node */
  public LirNode subReg(int opCode, int type, LirNode src, int pos, ImList opt);

  /** Create LABEL node */
  public LirNode labelRef(int opCode, int type, Label label, ImList opt);

  /** Create LABEL node, short form */
  public LirNode labelRef(Label label);

  /** Create unary operator node */
  public LirNode operator(int opCode, int type, LirNode operand, ImList opt);

  /** Create binary operator node */
  public LirNode operator(int opCode, int type, LirNode operand0, LirNode operand1, ImList opt);

  /** Create ternary operator node */
  public LirNode operator(int opCode, int type, LirNode operand0,
                          LirNode operand1, LirNode operand2, ImList opt);

  /** Create n-ary operator node */
  public LirNode operator(int opCode, int type, LirNode operands[], ImList opt);

  /** Make a copy of node */
  public LirNode makeCopy(LirNode inst);
}
