package coins.backend.sym;

import java.io.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.lir.*;

/** Symbol table entry */
public abstract class Symbol {
  public final SymTab table;
  public final String name;
  public final int id;
  public final int storage;
  public final int type;
  public final int boundary;
  public final ImList opt;

  // LirNode refNode;

  /** DEPRECATED: Miscellaneous flags */
  int flags;

  /** DEPRECATED: Register objects' original variable */
  Symbol shadow;

  /** DEPRECATED: This variable was taken its address. */
  public static final int F_ADDRTAKEN = 1;

  Symbol(SymTab table, String name, int id, int storage, int type, int boundary,
         ImList opt) {
    this.table = table;
    this.name = name;
    this.id = id;
    this.storage = storage;
    this.type = type;
    this.boundary = boundary;
    this.opt = opt == null ? ImList.Empty : opt;
  }


  /** Create new symbol from listarg **/
  static Symbol parseSymbol(SymTab table, int id, ImList list)
    throws SyntaxError {

    String name = ((QuotedString)list.elem()).body;
    int tag = Storage.decode((String)list.elem2nd());
    int type = Type.decode((String)list.elem3rd());
    int boundary, offset;

    switch (tag) {
    case Storage.STATIC:
      boundary = Integer.parseInt((String)list.elem4th());
      return new SymStatic(table, name, id, tag, type, boundary,
                           ((QuotedString)list.elem5th()).body,
                           (String)list.elem6th(),
                           list.scanOpt());

    case Storage.FRAME:
      boundary = Integer.parseInt((String)list.elem4th());
      offset = Integer.parseInt((String)list.elem5th());
      return new SymAuto(table, name, id, tag, type, boundary, offset,
                         list.scanOpt());

    case Storage.REG:
    default:
      if (list.length() < 5 || ((String)list.elem5th()).charAt(0) == '&') {
        boundary = 0;
        offset = Integer.parseInt((String)list.elem4th());
      } else {
        boundary = Integer.parseInt((String)list.elem4th());
        offset = Integer.parseInt((String)list.elem5th());
      }
      return new SymAuto(table, name, id, tag, type, boundary, offset,
                         list.scanOpt());
    }
  }


  /** DEPRECATED: Test if the given flag is up.
   *  (true returned when the flag is up) */
  public boolean testFlag(int flag) {
    return ((flags & flag) != 0);
  }

  /** DEPRECATED: Set flag 0 or 1 */
  public void setFlag(int flag, boolean yes) {
    if (yes)
      flags |= flag;
    else
      flags &= ~flag;
  }

  /** Prepend space only if x is nonnull string **/
  String preSpace(String x) {
    return (x.length() == 0) ? x : " " + x;
  }

  /** Visualize flags field. */
  String flagsToString() {
    return (flags & F_ADDRTAKEN) != 0 ? "&addrtaken" : "";
  }

  /** DEPRECATED: Return the shadow variable (original/register variable) */
  public Symbol shadow() { return shadow; }

  /** DEPRECATED: Set original/shadow variable */
  public void setShadow(Symbol another) {
    shadow = another;
  }

  // /** Set LirNode which refers to this symbol */
  // public void setRefNode(LirNode node) {
  //   refNode = node;
  // }

  // /** Return LirNode which refers to this symbol */
  // public LirNode refNode() {
  //   return refNode;
  // }

  public abstract String toString();
}
